/** 
 *  Yudit Unicode Editor Source File
 *
 *  GNU Copyright (C) 2002  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2001  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2000  Gaspar Sinai <gsinai@yudit.org>  
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#ifndef SCluster_h
#define SCluster_h
#include "stoolkit/STypes.h"

#define SD_YUDIT 0
/* ligature 0x8001xxxx */
#define SD_DEVANAGARI 1
/* ligature 0x8002xxxx */
#define SD_BENGALI 2
/* ligature 0x8003xxxx */
#define SD_GURMUKHI 3
/* ligature 0x8004xxxx */
#define SD_GUJARATI 4
/* ligature 0x8005xxxx */
#define SD_ORIYA 5
/* ligature 0x8006xxxx */
#define SD_TAMIL 6
/* ligature 0x8007xxxx */
#define SD_TELUGU 7
/* ligature 0x8008xxxx */
#define SD_KANNADA 8
/* ligature 0x8009xxxx */
#define SD_MALAYALAM 9
/* ligature 0x800axxxx */
#define SD_SINHALA 10
#define SD_SCRIPT_MAX 11

/**
 * This one generates ligature on the non-displayable cluster 
 */
unsigned int getCluster (const SV_UCS4& ucs4, unsigned int index, 
   SV_UCS4* ret, int* finished=0);

void putLigatureUnicode (SS_UCS4 ligature, const SS_UCS4* code, 
 unsigned int size);

void putLigatureCluster (SS_UCS4 ligature, const SS_UCS4* code, 
 unsigned int size);

unsigned int getLigatureUnicode (SS_UCS4 ligature, SS_UCS4* buffer);
unsigned int getLigatureCluster (SS_UCS4 ligature, SS_UCS4* buffer);

bool isLigature (SS_UCS4 _comp);

/* get script name or null */
char* getLigatureScript (SS_UCS4 comp);
int   getLigatureScriptCode (SS_UCS4 comp);

int getCharType (SS_UCS4 unchar);

/* get the index */
int getUnicodeScript (SS_UCS4 comp);
bool isCoveredScipt (SS_UCS4 comp, int scipt);

SS_UCS4 getHalant (int index);

SS_UCS4 getLRVowelLeft (SS_UCS4 u);
SS_UCS4 getLRVowelRight (SS_UCS4 u);


#define SD_INDIC_CONSONANT 0x1
#define SD_INDIC_HALANT 0x2
#define SD_INDIC_INDEP_VOWEL 0x3
#define SD_INDIC_LEFT_VOWEL 0x4
#define SD_INDIC_RIGHT_VOWEL 0x5
#define SD_INDIC_TOP_VOWEL 0x6
#define SD_INDIC_BOTTOM_VOWEL 0x7
#define SD_INDIC_SIGN 0x8
#define SD_INDIC_ZWJ 0x9
#define SD_INDIC_ZWNJ 0xa

#define SD_INDIC_NUKTA 0xc
#define SD_INDIC_MODIFIER 0xd
#define SD_INDIC_LEFT_RIGHT_VOWEL 0xe

#endif /* SCluster_h */
