/** 
 *  Yudit Unicode Editor Source File
 *
 *  GNU Copyright (C) 2002  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2001  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2000  Gaspar Sinai <gsinai@yudit.org>  
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#ifndef SCanvas_h
#define SCanvas_h

#include "swindow/SPen.h"
#include "swindow/SImage.h"
#include "stoolkit/SMatrix.h"
#include "stoolkit/STypes.h"
#include "stoolkit/SUniqueID.h"
#include "stoolkit/SString.h"

/**
 * @author: Gaspar Sinai <gsinai@yudit.org>
 * @version: 2000-04-23
 * This is the abstract widget toolkit package
 */
class SCanvas
{
public:
  SCanvas (void); 
  virtual ~SCanvas (); 

  virtual bool cacheOn (bool on=true);
  virtual bool newpath (double x, double y, const SString& id);
  virtual void fill (const SPen& pen);
  virtual void stroke(const SPen& pen);

  virtual void moveto (double x, double y);
  virtual void lineto (double x, double y);
  virtual void curveto (double x0, double y0, double x1, 
          double y1, double x3, double y3);
  virtual void closepath();
  virtual void pushmatrix();
  virtual void popmatrix();
  virtual void scale (double x, double y);
  virtual void translate (double x, double y);
  virtual void rotate (double angle);
  virtual SS_Matrix2D  getCurrentMatrix() const;
  
  virtual void putImage (int x, int y, const SImage& image);
  virtual void setBackground(const SColor &color);

  /*
   * the following 3 routines might not be implemented for a canvas, 
   * without a pixel device
   */
  virtual void bitfont (const SPen& pen, double x, double y, void* native, char* data, unsigned int len);
  virtual void bitfill (const SColor& bg, int x, int y, unsigned int width, unsigned int height);
  virtual void bitline (const SColor& fg, int x, int y, int tox, int toy);
  virtual void bitpoint (const SColor& fg, int x, int y);
protected:
  bool isCacheOn;
};

#endif /* SCanvas_h */
