/** 
 *  Yudit Unicode Editor Source File
 *
 *  GNU Copyright (C) 2002  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2001  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2000  Gaspar Sinai <gsinai@yudit.org>  
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "stoolkit/SConfig.h"
#include "stoolkit/SEncoder.h"
#include <stdlib.h>
#include <stdio.h>
#include "swindow/SAwt.h"
#include "swindow/SFont.h"
#ifndef USE_WINAPI
#include <sys/time.h>
#else
#include <winsock.h>
#include <time.h>
// Hacked for winapi coming from stoolkit/SEventBSD.cpp
extern int gettimeofday (struct timeval* tv, void* tz);
#endif


#define DEFAULT_CONFIG "/usr/share/yudit/config/yuditrc"

void timerStart();
void timerStop();

class Listener : public SWindowListener
{
public:
  Listener() : SWindowListener() {}
  ~Listener() {}
  virtual void redraw(SWindow* w, int x, int y, 
    unsigned int width ,unsigned int height);
  virtual bool windowClose (SWindow* w)
  {
    //fprintf (stderr, "Window closing..\n");
    return true;
  }
};

void drawIt (SWindow * w);
void
Listener::redraw (SWindow* w, int x, int y, unsigned int width ,
  unsigned int height)
{
  timerStart();
  drawIt(w);
  timerStop();
}

SFont font("English");
double pointsize = 24;

SString testString("東京都目黒区卑文谷");

void drawIt (SWindow * w)
{
  double pensize=1;
  if (pointsize <= 16)
  {
   pensize = 0.125;
  }
  else if (pointsize <=24)
  {
   pensize = 0.25;
  }
  else if (pointsize <=80)
  {
   pensize = 0.5;
  }
  else if (pointsize <=100)
  {
   pensize = 0.75;
  }
  
  //SPen pen (SColor(0.0,0.0,0.0, 1.0), SColor(1.0, 1.0, 1.0, 1.0), pensize);
  SPen pen (SColor(0.0,0.0,0.0, 1.0), SColor(0.8, 0.5, 0.7, 1.0), pensize);
  SS_Matrix2D matrix;
  matrix.y1 = -matrix.y1;

  double ascent = font.ascent ();
  double descent = font.descent ();
  double gap = font.gap ();

  matrix.translate (0, ascent + gap);
  SS_Matrix2D origo = matrix;

  SEncoder ic;
  SV_UCS4 res = ic.decode (testString, false);
  unsigned int line=0;
  unsigned int column=0;
  unsigned int i=0;
  //res.insert (0, 0x10000);
  while (i<res.size())
  {
     double wd = font.width (&res.array()[i], i-res.size(), 0);

     unsigned int wi = (unsigned int) (wd+1.0);
     if (column + wi > w->getWidth()) 
     {
       line++; column = 0;
       matrix = origo;
       matrix.translate (0, double (line) * (ascent+gap+descent));
     }
     unsigned int adv = font.draw (w, pen, matrix, &res.array()[i], res.size()); 
     i+= adv;
     column += wi;
     matrix.translate (double (wi), 0);
  }
}

/**
 * @author: Gaspar Sinai <gsinai@yudit.org>
 * @version: 2000-04-23
 */
main (int argc, char* argv[])
{
  if (argc < 2)
  {
    fprintf (stderr, "Usage: main point.size [text]\n");
    return 0;
  }
  sscanf (argv[1], "%lf", &pointsize);
  if (argc > 2)
  {
    SFile f (argv[2]);
    
    SFileImage im = f.getFileImage();
    testString = (f.size()<0) ? SString (argv[2]) 
     : SString (im.array(), f.size());
  }
  
  SAwt awt;
  
  if (!awt.implemented())
  {
    fprintf (stderr, "AWT is not implemented!\n");
    return 0;
  }
  SFontImplVector list;
  SStringVector ml("timesbi.ttf,arial.ttf,cyberbit.ttf");
  //SStringVector ml("-sony-fixed-medium-r-normal--24-230-75-75-c-120-iso8859-1");
  //SStringVector ml("-*-*-*-*-*--*-*-*-*-*-*-jisx0208.1983-0");
  //SStringVector ml("timesbi.ttf,arial.ttf,jisx0208.1983-0,iso8859-1,cyberbit.ttf");
  for (unsigned int h=0; h<ml.size(); h++)
  {
    SFontImpl impl (ml[h], ml[h]);
    list.append (impl);
  }
  SFont::put ("English", list);
  font = SFont("English");
  font.setSize (pointsize);
  SWindow* w = awt.getWindow(new Listener(), "Gaspar WINDOW");
  //w->setBackground (SColor(1.0, 1.0, 1.0, 1.0));
  w->setBackground (SColor(0.8, 0.5, 0.7, 1.0));
  w->resize (750, 320);

  w->show(); 
  SEventHandler::start();
  return 0;
}

struct timeval thatTime;
void
timerStart()
{
  gettimeofday (&thatTime, 0);
}

void 
timerStop()
{
  struct timeval thisTime;
  gettimeofday (&thisTime, 0);
  if (thisTime.tv_usec < thatTime.tv_usec)
  {
    thisTime.tv_sec--;
    thisTime.tv_usec+=1000000;
  }
  thisTime.tv_sec -= thatTime.tv_sec;
  thisTime.tv_usec -= thatTime.tv_usec;
  int msec = thisTime.tv_sec * 1000 + thisTime.tv_usec/1000;
  fprintf (stderr, "Elapsed time: %d msecs\n", msec);
}
