/** 
 *  Yudit Unicode Editor Source File
 *
 *  GNU Copyright (C) 2002  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2001  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2000  Gaspar Sinai <gsinai@yudit.org>  
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#include "stoolkit/SUniMap.h"
#include <stdio.h>

int test (const SString& a1);
int test2 (const SString& a1, const SString& a2);
main (int argc, char* argv[])
{
  if (argc != 2 && argc != 3)
  {
    fprintf (stderr, "usage:   %s mapmame [outmap]\n", argv[0]);
    fprintf (stderr, "example: %s Hungarian iso-8859-2\n", argv[0]);
    return 1;
  }
  if (argc == 2) return test(argv[1]);
  if (argc == 3) return test2(argv[1], argv[2]);
  return 1;
}

int
test (const SString& a1)
{
  SUniMap u (a1);

  if (!u.isOK())
  {
    fprintf (stderr, "Could not load unimap %*.*s\n", SSARGS(a1));
    return 1;
  }
  fprintf (stdout, "Please enter string to decode:\n");
  fflush (stdout);
  char line[256];
  while (fscanf(stdin, "%s", line)==1)
  {
    SV_UCS4 v = u.decode (line);
    for (unsigned int i=0; i<v.size(); i++)
    {
      fprintf (stdout, "U+%04x ", v[i]);
    }
    fprintf (stdout, "\n");
    fflush (stdout);
  }
  return 0;
}

int
test2 (const SString& a1, const SString& a2)
{
  SUniMap u (a1);
  SUniMap u2 (a2);

  if (!u.isOK())
  {
    fprintf (stderr, "Could not load unimap %*.*s\n", SSARGS(a1));
    return 1;
  }
  if (!u2.isOK())
  {
    fprintf (stderr, "Could not load unimap %*.*s\n", SSARGS(a2));
    return 1;
  }
  fprintf (stdout, "Please enter string to decode:\n");
  fflush (stdout);
  char line[256];
  while (fgets(line, sizeof(line), stdin))
  {
    SV_UCS4 v = u.decode (line);
    SString s = u2.encode (v);
    fprintf (stderr, "%*.*s", SSARGS(s));
    fflush (stdout);
  }
  return 0;
}
