/** 
 *  Yudit Unicode Editor Source File
 *
 *  GNU Copyright (C) 2002  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2001  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2000  Gaspar Sinai <gsinai@yudit.org>  
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <string.h>
#include <swidget/SFrame.h>
#include <swidget/SLayout.h>
#include <swidget/STextEdit.h>
#include <stoolkit/SEvent.h>
#include <stoolkit/SIO.h>
#include <swidget/SSlider.h>
#include <stoolkit/SBinHashtable.h>
#include <swidget/SLabel.h>
#include <swidget/SButton.h>
#include <swidget/STextList.h>
#include <swidget/SFileDialog.h>
#include <stoolkit/SBinVector.h>
#include <stoolkit/SBinHashtable.h>

class WML : public SFrameListener
{
public:
  virtual bool close (SPanel* comp) 
  {
    //fprintf (stderr, "Closing window %lx\n", (unsigned long) comp);
    return true;
  };
};

static void truncateUTF8 (SString * str, unsigned int size);


int
main (int argc, char* argv[])
{
  SBinHashtable<void*> bh;
  bh.put ("arial.ttf", 1234);
  SBinHashtable<void*> bc;
  bc = bh;
  bc.remove ("arial.ttf");
  exit (0);
  SBinVector<int> intv;
  intv.append (0x10000);
  intv.append (0x20000);
  intv.append (0x30000);
  fprintf (stderr, "find=%d\n", intv.find(0x20000));
  exit (0);
  /*fffe 2efb d005 2d20 b705 0a00*/
  fprintf (stderr, "testing precompose 05D0 202D 05B7 0A00\n");
  SUniMap enc("precompose");
  unsigned int ari;
  SV_UCS4 ariv;
  if (!enc.isOK())
  {
    fprintf (stderr, "can not get enco\n");
    exit (1);
  }
  unsigned int last=0;
  while (true)
  {
    ari=0;
    scanf ("%x", &ari);
    if (ari==0)
    {
       continue;
    }
    ariv.append (ari);
    SV_UCS4 prec;
    unsigned int  len = enc.lift (ariv, last, false, &prec);
    fprintf (stderr, "len=%u\n", len);
    if (len!=last)
    {
      unsigned int i;
      for (i=last; i<len; i++)
      {
        printf ("%X ", (unsigned int) ariv[i]);
      }
      printf ("-> ");
      for (i=0; i<prec.size(); i++)
      {
       printf ("%X ", (unsigned int) (prec[i]));
      }
      printf ("\n");
      last = len;
    }
  }
#if 0
#endif
  SFontImplVector list;
  //SStringVector ml("-*-*-*-*-*--*-*-*-*-*-*-jisx0208.1983-0");
  //SStringVector ml(".ttf,arial.ttf,jisx0208.1983-0,iso8859-1,cyberbit.ttf");
  SFrame *frame = new SFrame();

  SStringVector ml("-gnu-unifont-medium-r-normal--16-160-75-75-c-80-iso10646-1,*-iso8859-1");
  unsigned int h;
  for (h=0; h<ml.size(); h++)
  {
    SFontImpl impl (ml[h], ml[h]);
    list.append (impl);
    SFont::put ("Bitmap", list);
  }
  ml = SStringVector("timesbd.ttf,arial.ttf,msgothic.ttf,gulim.ttf,cyberbit.ttf");
  //ml = SStringVector("cyberbit.ttf");
  list.clear();
  for (h=0; h<ml.size(); h++)
  {
    if (ml[h] == "kanjia.ttf")
    {
      SFontImpl impl (ml[h], "-*-*-*-*-*--*-*-*-*-*-*-iso8859-1");
      list.append (impl);
    }
    else
    {
      SFontImpl impl (ml[h], ml[h]);
      list.append (impl);
    }
    SFont::put ("TrueType", list);
  }

  WML *windowListener = new WML();
  frame->setFrameListener (windowListener);

  frame->forceLayout (SLayout ( SLocation (0,0), SLocation (300,200)));
  STextList* textList = new STextList();
  
  textList->forceLayout (
    SLayout (
       SLocation (80, 5),
       SLocation (125, 95),
       SLocation (0, 0),
       SLocation (100, 100))
  );

  SSlider* slider = new SSlider();
  slider->forceLayout (
    SLayout (
       SLocation (125, 5), 
       SLocation (150, 95),
       SLocation (100, 0),
       SLocation (100, 100)
    )
  );
    
  SColor c("gray50");
  SColor metal((unsigned char) 73,
      (unsigned char) 121, (unsigned char) 134, (unsigned char) 255);
  slider->setBackground (c);
  slider->setSliderBackground (metal);

  //slider->set (20, 1, 20, 100, true);
  frame->setBackground (c);
  textList->setBackground (c);
  textList->setText (SStringVector("one,two,three,four,five,size,seven,eight,nine,ten,eleven,twelve,thirteen,fourteen,fifteen,sizteen,seventeen,eighteen,nineteen,twenty"));
  textList->setTextBackground (SColor("white"));
  textList->setForeground (SColor("black"));

  //textList->setSelectedBackground (SColor("blue"));
  //textList->setSelectedForeground (SColor("white"));

  frame->add (textList);
  frame->add (slider);

  frame->resize(SDimension(600, 400));
  frame->setTitle ((argc == 2) ? argv[1] : "Nooo");
  //frame->show();
  SFileDialog* filer = new SFileDialog();

  SDimension d = filer->getPreferredSize();
  filer->setMinimumSize(d);
  filer->resize(d);
  filer->setBackground (c);
  filer->setBackground (c);
  filer->setFileType ("utf-8");
  filer->getInput("Open", false, false);
  //SEventHandler::start();
  return 0;
}

static void
truncateUTF8 (SString * str, unsigned int size)
{
  unsigned int k = 0;
  unsigned int i = 0;
  while (i<str->size() && k < size)
  {
     unsigned int utfsize = 1;
     if (((unsigned char) (*str)[i] & 0xe0) ==0xc0)
     {
        utfsize = 2;
     }
     else if (((unsigned char) (*str)[i] & 0xf0) ==0xe0)
     {
        utfsize = 3;
     }
     i += utfsize; 
     k++;
  }
  if (i>=str->size())
  {
    return;
  }
  else if (i==0) 
  {
     str->clear();
     return;
  }
  str->truncate (i);
  return;
}
