/* zbconfig.hh 
 * (c) 2002 Christian Tpp <c.toepp@gmx.de>
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ZBCONFIG_H
#define ZBCONFIG_H

#include <qlayout.h>
#include <qgrid.h>
#include "zbtabwidget.hh"
#include "computerview.hh"
#include "zbuser.hh"
#include "userparkview.hh"

class zbconfig : public QObject
{
Q_OBJECT
public:
  zbconfig (QString location);
  ~zbconfig ();
  int readConfig (tarifList * tarife, productList * products,
		  groupList * groups, companyInfo * company, QString * cur,
		  int *park, printInfo * pInfo);
  int writeConfig (tarifList * tarife, productList * products,
		   groupList * groups, companyInfo * company, QString * cur,
		   int *park, printInfo * pInfo);
  int readDb(tarifList *tarife, productList *products,printInfo *pInfo);
  int writeDb(parkList *park,groupList *groups);
private:
    QString file;
signals:
  void parkUser(zbuser *user);
  void compUser(zbuser *user, QString comp, QString client);
};

#endif
