# **********************************************************************
#
# Copyright (c) 2003-2007 ZeroC, Inc. All rights reserved.
#
# This copy of Ice is licensed to you under the terms described in the
# ICE_LICENSE file included in this distribution.
#
# **********************************************************************

top_srcdir	= ..\..\..

CLIENT		= client.exe

TARGETS		= $(CLIENT)

OBJS		= ComplexDict.obj \
		  Complex.obj \
		  Grammar.obj \
		  Scanner.obj \
		  Parser.obj \
		  Client.obj

SRCS		= $(OBJS:.obj=.cpp)

!include $(top_srcdir)\config\Make.rules.mak

CPPFLAGS	= -I. -Idummyinclude -I../../include $(CPPFLAGS) -DWIN32_LEAN_AND_MEAN

!if "$(CPP_COMPILER)" != "BCC2006" && "$(OPTIMIZE)" != "yes"
PDBFLAGS        = /pdb:$(CLIENT:.exe=.pdb)
!endif

$(CLIENT): $(OBJS)
	$(LINK) $(LD_EXEFLAGS) $(PDBFLAGS) $(SETARGV) $(OBJS) $(PREOUT)$@ $(PRELIBS)$(LIBS) freeze$(LIBSUFFIX).lib
	@if exist $@.manifest echo ^ ^ ^ Embedding manifest using $(MT) && \
	    $(MT) -nologo -manifest $@.manifest -outputresource:$@;#1 && del /q $@.manifest

ComplexDict.h ComplexDict.cpp: Complex.ice $(SLICE2FREEZE)
	del /q ComplexDict.h ComplexDict.cpp
	$(SLICE2FREEZE) -I$(slicedir) --dict Complex::ComplexDict,Complex::Key,Complex::Node ComplexDict Complex.ice

#Scanner.cpp : Scanner.l
#	flex Scanner.l
#	del /q $@
#	echo #include "IceUtil/Config.h" > Scanner.cpp
#	type lex.yy.c >> Scanner.cpp
#	del /q lex.yy.c

#Grammar.cpp Grammar.h: Grammar.y
#	del /q Grammar.h Grammar.cpp
#	bison -dvt Grammar.y
#	move Grammar.tab.c Grammar.cpp
#	move Grammar.tab.h Grammar.h
#	del /q Grammar.output

clean::
	del /q Complex.cpp Complex.h
#	del /q Grammar.cpp Grammar.h
#	del /q Scanner.cpp
	del /q ComplexDict.h ComplexDict.cpp
	for %f in (db\*) do if not %f == db\.gitignore del /q %f

!include .depend
