/*____________________________________________________________________________

   Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

   Copyright (C) 1999 EMusic

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   $Id: ThemeManager.h,v 1.5 2003/09/16 17:35:32 kgk Exp $
____________________________________________________________________________*/ 

#ifndef INCLUDED_THEMEMANAGER_H__
#define INCLUDED_THEMEMANAGER_H__

// The debugger can't handle symbols more than 255 characters long.
// STL often creates symbols longer than that.
// When symbols are longer than 255 characters, the warning is disabled.
#include "config.h"
#ifdef WIN32
#pragma warning(disable:4786)
#endif

#include <string>
#include <map>
#include "errors.h"
#include "facontext.h"


class ThemeManager
{
    public:

               ThemeManager(FAContext *pContext);
      virtual ~ThemeManager(void);

      virtual Error GetDefaultTheme(std::string& themeName, std::string &themePath);
      virtual Error GetThemeList   (std::map<std::string, std::string> &oThemeFileList);
      virtual Error UseTheme       (std::string &oThemeFile);
      virtual Error AddTheme       (std::string &oThemeFile, bool bRename = false);
      virtual Error DeleteTheme    (std::string &oThemeFile);
      virtual Error GetCurrentTheme(std::string &oTheme);

    protected:
    
/*       bool          GetDescriptiveName(std::string &oThemeFile,  */
/*     				       std::string &oThemeName); */
	
    private:

      std::string     m_oCurrentTheme, m_oDevelTheme;
      FAContext *m_pContext;
      bool       m_bDevelTheme;
};

#endif

/* arch-tag: 9cf33aa3-4cc3-4fb0-b2a8-3bfbdeafb978
   (do not change this comment) */
