
from Testing import ZopeTestCase
from Products.CMFPlone.tests import PloneTestCase

ZopeTestCase.installProduct('Archetypes')
ZopeTestCase.installProduct('PortalTransforms', quiet=1)
ZopeTestCase.installProduct('MimetypesRegistry', quiet=1)

# Make sure the dummy types are registered
from Products.CMFBibliographyAT.tests import dummy
ZopeTestCase.installProduct('CMFBibliographyAT')

from AccessControl.SecurityManagement import newSecurityManager
from AccessControl.SecurityManagement import noSecurityManager
from Products.CMFCore.utils import getToolByName
import time

PORTAL_OWNER = PloneTestCase.portal_owner
PORTAL_NAME = PloneTestCase.portal_name
DEFAULT_USER = PloneTestCase.default_user


def quickinstallProduct(app, portal_name, product_name, quiet=0):
    '''Adds product to portal using Quickinstaller.'''
    # Login as portal owner
    user = app.acl_users.getUserById(PORTAL_OWNER).__of__(app.acl_users)
    newSecurityManager(None, user)
    # Add product with Quickinstaller
    qi = getToolByName(app[portal_name], 'portal_quickinstaller')
    if not qi.isProductInstalled(product_name):
        if qi.isProductInstallable(product_name):
            start = time.time()
            if not quiet: ZopeTestCase._print('Adding %s ... ' % (product_name,))
            qi.installProduct(product_name)
            if not quiet: ZopeTestCase._print('done (%.3fs)\n' % (time.time()-start,))
        else:
            if not quiet: ZopeTestCase._print('NOT INSTALLABLE\n')
    # Log out and commit
    noSecurityManager()
    get_transaction().commit()


def setupCMFBibliographyAT(app, portal_name, quiet):
    quickinstallProduct(app, portal_name, 'Archetypes', quiet)
    quickinstallProduct(app, portal_name, 'CMFBibliographyAT', quiet)

ZopeTestCase.utils.appcall(setupCMFBibliographyAT, PORTAL_NAME, quiet=0)


# This is so we can find our own files
from Products.CMFBibliographyAT.tests import GLOBALS
from Globals import package_home
PACKAGE_HOME = package_home(GLOBALS)

from os.path import join
MEDLINE_TEST_MED = join(PACKAGE_HOME, 'medline_test.med')
MEDLINE_TEST_BIB = join(PACKAGE_HOME, 'medline_test.bib')
BIBTEX_TEST_BIB = join(PACKAGE_HOME, 'bibtex_test.bib')

