##############################################################################
#
# Copyright (c) 2002 Ingeniweb SARL
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
#
##############################################################################

"""
Plone Article core classes for images and attachments and layout models
"""

from AccessControl import ClassSecurityInfo
import Acquisition
import string
import random
import os
from Products.CMFCore import CMFCorePermissions
from AccessControl import Permissions, getSecurityManager, ClassSecurityInfo, Unauthorized
from OFS import Folder, Image, ObjectManager
from Products.ZAttachmentAttribute import ZAttachmentAttribute
from DateTime import DateTime
from global_symbols import *
from Products.CMFCore.utils import getToolByName
from Products.PloneArticle.Installation import Installation


#                                                                           #
#                           LOCKING SUPPORT                                 #
#                                                                           #


class ArticleLock(Acquisition.Implicit):

    security = ClassSecurityInfo()
    _has_lock_support = 1

    # Init method
    security.declarePrivate('__init__')
    def __init__(self):
        """__init__(self)"""
        self._article_locked = 0
        self._article_locked_by = None
        self._article_locked_date = None
        self._article_unlocked_by = None
        self._article_unlocked_date = None


    security.declarePrivate('_post_init')
    def _post_init(self,):
        """
        _post_init(self,)
        """
        # Lock article to allow the user to edit it
        self.lockArticle()
        

    #                                                                           #
    #                             LOCKING SUPPORT                               #
    #                                                                           #

    security.declareProtected(PloneArticle_lockPermission, 'toggle_lock')
    def toggle_lock(self):
        """
        toggle_lock(self)

        Returns 'locked' or 'unlocked' string
        """
        locked = getattr(self, '_article_locked', 0)
        if locked:
            self.unlockArticle()
        else:
            self.lockArticle()

        return ['unlocked','locked',][self._article_locked]

    security.declarePrivate("lockArticle")
    def lockArticle(self,):
        """
        lock article
        """
        return self.setLockStatus(1)

    
    security.declarePrivate("unlockArticle")
    def unlockArticle(self,):
        """
        unlock article
        """
        return self.setLockStatus(0)


    security.declarePrivate("setLockStatus")
    def setLockStatus(self, lock):
        """
        lock or unlock
        """
        Log(LOG_DEBUG, self.get_local_roles())
        
        # Check if we can really lock the article
        portal_article = getToolByName(self, "portal_article")
        if not portal_article.hasLockSupport():
            return

        # Get member information
        portal_membership = getToolByName(self, 'portal_membership')
        now = DateTime()
        username = portal_membership.getAuthenticatedMember().getUserName()
        userid = portal_membership.getAuthenticatedMember().getMemberId()

        # Remove all LockOwner local roles
        for user, roles in self.get_local_roles():
            Log(LOG_DEBUG, "user,roles", user, roles)
            if "LockOwner" in roles:
                new_roles = filter(lambda x: x != 'LockOwner', list(roles))
                if new_roles:
                    self.manage_setLocalRoles(user, new_roles)
                else:
                    self.manage_delLocalRoles([user,],)
                
        # Apply locking
        if lock:
            self._article_locked=1
            self._article_locked_by=username
            self._article_locked_date=now
            
            # Use LockOwner local role if it's available
            self.manage_addLocalRoles(userid = userid, roles = ['LockOwner',])
        else:
            self._article_locked=0
            self._article_unlocked_by=username
            self._article_unlocked_date=now

        # Return status information
        Log(LOG_DEBUG, self.get_local_roles())
        return ['unlocked','locked',][self._article_locked]
        

    # The isLocked() method has been moved to the article core so that
    # articles without locking support can be created.
##    security.declareProtected(CMFCorePermissions.View, 'isLocked')
##    def isLocked(self):
##        """Returns 1 if the article is locked otherwise 0"""
##        locked = getattr(self, '_article_locked', 0)
##        return locked

    security.declareProtected(CMFCorePermissions.View, 'getLockUser')
    def getLockUser(self):
        """Returns the username of the member which has locked the document"""
        locked_by = getattr(self, '_article_locked_by', None)
        return locked_by

    security.declareProtected(CMFCorePermissions.View, 'getLockDate')
    def getLockDate(self):
        """Returns the date when the article was locked"""
        locked_date = getattr(self, '_article_locked_date', None)
        return locked_date


    security.declareProtected(CMFCorePermissions.View, 'canToggleLock')
    def canToggleLock(self):
        """
        canToggleLock(self,) => return 1 if the current user can switch the lock status
        """
        # Return lock support
        portal_article = getToolByName(self, "portal_article")
        if not portal_article.hasLockSupport():
            return 0
        
        portal_membership = getToolByName(self, 'portal_membership')
        member = portal_membership.getAuthenticatedMember()

        # Check if he has the lock permission
        if not member.has_permission(PloneArticle_lockPermission, self):
            return 0

        # Check, if the content is locked, that it's the same user OR it's a manager
        can_toggle = 0
        if self.isLocked():
            # If it is the current user, allow him to unlock
            if member.getUserName() == self.getLockUser():
                can_toggle = 1
            else:
                # Else, allow managers
                for role in PloneArticle_unlockRoles:
                    if member.has_role(role, self):
                        can_toggle = 1
                        break
        else:
            can_toggle = 1

        # Return the toggling value
        return can_toggle




