# Copyright (c) 2003-2006 Ingeniweb SAS

# This software is subject to the provisions of the GNU General Public
# License, Version 2.0 (GPL).  A copy of the GPL should accompany this
# distribution.  THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL
# EXPRESS OR IMPLIED WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY,
# AGAINST INFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE

# More details in the ``LICENSE`` file included in this package.

"""
Plone Article core classes for images and attachments and layout models
"""

# Zope imports
from AccessControl import ClassSecurityInfo
import Acquisition
from DateTime import DateTime
from Globals import InitializeClass

# CMF imports
from Products.CMFCore import CMFCorePermissions
from Products.CMFCore.utils import getToolByName

# Archetypes imports
from Products.Archetypes.public import *

# PloneArticle imports
from Products.PloneArticle import Permissions
from Products.PloneArticle.LockMixin import LockMixin
from Products.PloneArticle.config import *


#                                                                           #
#                           LOCKING SUPPORT                                 #
#                                                                           #


class LockWidget(BooleanWidget):
      """
      Visibility depends on Lock support
      """
      
      security = ClassSecurityInfo()
      
      security.declarePublic('isVisible')
      def isVisible(self, instance, mode='view'):
          state = BooleanWidget.isVisible(self, instance, mode)
          
          if mode == 'edit':
              state = 'hidden'
          
              # Removing bogus code 2005/07/28 MR
              #
              # Return lock support
              #portal_article = getToolByName(self, "portal_article")
              #if portal_article.hasLockSupport():
              #    return 'hidden'
              #else:
              #    return 'hidden'
              
          return state

InitializeClass(LockWidget)

class ArticleLock(LockMixin):

    LockOwnerPermission = Permissions.LockPloneArticle
    LockEditPermission = Permissions.EditPloneArticle
    
    security = ClassSecurityInfo()

    schema = Schema((
        # Locked Mixin
        BooleanField('is_locked',
                    accessor='isLocked',
                    mutator='lock',
                    default=False,
                    widget=LockWidget(
                        visible={'view' : 'hidden',
                                 'edit' : 'hidden'},
            )),
        ))

    security.declareProtected(CMFCorePermissions.View, 'hasLockSupport')
    def hasLockSupport(self):
        portal_article = getToolByName(self, "portal_article")
        return portal_article.hasLockSupport()
