# ReplaceSupport 1.0.2
# (c) 2000-2004, Stefan H. Holek, stefan@epy.co.at
# http://zope.org/Members/shh/ReplaceSupport
# License: ZPL
# Zope: 2.3-2.7

__doc__ = 'ReplaceHandler base class'
__version__ = '0.2.0'

# *must* set this attribute to the respective handler's class 
# name in each handler module
#
__handler_class_name__ = 'Must override!'

# derive your own handler class from this one
#
class ReplaceHandler:
	'''replace handler base class'''

	def getMetaType( self ):
		'''returns the target object's metatype as string'''
		return ''

	def getChangePermission( self ):
		'''returns the permission required to change the object (string).
		   modification is disallowed by default so you must override'''
		return ''

	def getBody( self, ob ):
		'''returns the target object's body as string'''
		return ''

	def getParams( self, ob ):
		'''returns the target object's parameters as string.
		   no need to override if the object at hand does not 
		   have a parameters attribute'''
		return ''
	
	def manageEdit( self, ob, body, params='' ):
		'''implements the changing of the target object's body
		   (and parameters). typically calls manage_edit'''
		pass

