###################################################################################################
# _versionmanager.py
#
# $Id: _versionmanager.py,v 1.12 2004/11/24 21:02:52 dnordmann Exp $
# $Name:  $
# $Author: dnordmann $
# $Revision: 1.12 $
#
# Implementation of class VersionManager (see below).
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
###################################################################################################

# Imports.
from __future__ import nested_scopes
from Globals import HTMLFile
import copy
import operator
import time
import urllib
# Product Imports.
import _accessmanager
import _globals 
import _blobfields 
import _workflowmanager
import _zmsattributecontainer

# DEPRECATED: Products.zms._myobjects.MyFile
class MyFile(_blobfields.MyFile): pass
# DEPRECATED: Products.zms._myobjects.MyImage
class MyImage(_blobfields.MyImage): pass


# ---------------------------------------------------------------------------------------------
#  _versionmanager.getObjStates:
#
#  Returns a list of object-states (including language suffixes).
# ---------------------------------------------------------------------------------------------
def getObjStates(self):
  # Get object-states.
  if not hasattr(self,'__work_state__'):
    self.__work_state__ = _globals.MyClass()
  states = getattr(self.__work_state__,'states',[])
  # Make object-states unique.
  d = {}
  map(lambda x: operator.setitem(d, x, None), states)
  states = d.keys()
  # Return object-states.
  return states


# ---------------------------------------------------------------------------------------------
#  _versionmanager.setChangedBy:
#
#  Applies information about user-id and date of change.
# ---------------------------------------------------------------------------------------------
def setChangedBy(self, REQUEST):
  lang = REQUEST.get('lang',self.getPrimaryLanguage())
  auth_user = REQUEST.get('AUTHENTICATED_USER',None)
  if auth_user is not None:
    # Set Properties.
    self.setObjProperty( 'change_lang' ,lang)
    self.setObjProperty( 'change_uid' ,str(auth_user) ,lang)
    self.setObjProperty( 'change_dt' ,time.localtime(time.time()) ,lang)
    self.setObjProperty( 'change_action' ,REQUEST.get('URL','/').split('/')[-1])


# ---------------------------------------------------------------------------------------------
#  _versionmanager.getObjStateName:
#
#  Returns name object state in given language.
# ---------------------------------------------------------------------------------------------
def getObjStateName(obj_state, lang):
  obj_state_name = obj_state
  if lang is not None:
    obj_state_name += '_'+lang.upper()
  return obj_state_name


# ---------------------------------------------------------------------------------------------
#  _versionmanager.pack:
#
#  Pack object (remove versions older than passed days) and process children.
# ---------------------------------------------------------------------------------------------
def pack(self, days=1): 
  try:
    now = time.time()
    #-- Get IDs.
    ids = []
    for ob in self.getObjVersions():
      delete = True
      for lang in self.getLangIds():
        req = {'lang':lang,'preview':'preview'}
        change_dt = ob.getObjProperty('change_dt',req)
        if change_dt is not None:
          delete = delete and _globals.daysBetween(change_dt,now) > days
      delete = delete and ob.id not in [self.version_live_id,self.version_work_id]
      if delete:
        ids.append( ob.id)
    #-- Delete objects.
    if len( ids) > 0:
      self.manage_delObjects( ids=ids)
    #-- Process child-objects.
    for ob in self.getChildNodes():
      pack( ob, days)
  except:
    _globals.writeException( self, "[pack]:")


# ---------------------------------------------------------------------------------------------
#  _versionmanager.doAutocommit:
#
#  Commit pending changes of all objects.
# ---------------------------------------------------------------------------------------------
def doAutocommit(self, REQUEST): 
  
  ##### Auto-Commit ####
  for lang in self.getLangIds():
    REQUEST.set( 'lang', lang)
    self.onChangeObj( REQUEST, forced=1)
    self.delObjStates( self.getWfStates( REQUEST), REQUEST)
  REQUEST.set('lang',lang)
  
  ##### Process child-objects ####
  for ob in self.getChildNodes():
    doAutocommit( ob, REQUEST)


###################################################################################################
###################################################################################################
###
###   class VersionManager
###
###################################################################################################
###################################################################################################
class VersionManager: 

    # Management Interface.
    # ---------------------
    version_object_state = HTMLFile('dtml/versionmanager/version_object_state', globals())

    """
    ###############################################################################################
    #  Workflow
    ###############################################################################################
    """

    # ---------------------------------------------------------------------------------------------
    #  WorkflowItem.getWfStates
    # ---------------------------------------------------------------------------------------------
    def getWfStates(self, REQUEST):
      states = getObjStates(self)
      lang = REQUEST.get('lang',None)
      obj_states = []
      for obj_state in self.getWfActivitiesIds():
          obj_state_name = getObjStateName(obj_state,lang)
          if obj_state_name in states:
            obj_states.append(obj_state)
      return obj_states


    # ---------------------------------------------------------------------------------------------
    #  VersionManager.isObjModified:
    # ---------------------------------------------------------------------------------------------
    def isObjModified(self, REQUEST):
      rtnVal = self.inObjStates( [ 'STATE_NEW', 'STATE_MODIFIED', 'STATE_DELETED' ], REQUEST )
      return rtnVal


    # ---------------------------------------------------------------------------------------------
    #  VersionManager.hasObjModifiedChildren:
    # ---------------------------------------------------------------------------------------------
    def hasObjModifiedChildren(self, REQUEST):
      
      #-- [ReqBuff]: Fetch buffered value from Http-Request.
      reqBuffId = 'hasObjModifiedChildren'
      try:
        rtnVal = self.fetchReqBuff( reqBuffId, REQUEST)
        return rtnVal
      except:
        
        rtnVal = False
        for child in self.getObjChildren( '', REQUEST ):
          if child.isObjModified(REQUEST):
            rtnVal = True
          # Special Objects / Link-Containers.
          elif (self.meta_type ==  'ZMSCustom' or \
	      child.meta_type == 'ZMSLinkContainer') and \
	     child.hasObjModifiedChildren( REQUEST ):
            rtnVal = True
          if rtnVal:
            break
        
        #-- [ReqBuff]: Returns value and stores it in buffer of Http-Request.
        return self.storeReqBuff( reqBuffId, rtnVal, REQUEST)


    # ---------------------------------------------------------------------------------------------
    #  VersionManager.resetObjTranslation:
    #
    #  Resets translation.
    # ---------------------------------------------------------------------------------------------
    def resetObjTranslation(self):
      for ob in self.getObjVersions():
        for lang in self.getLangIds():
          if lang != self.getPrimaryLanguage():
            setattr(ob,'change_uid_%s'%lang,'')


    # ---------------------------------------------------------------------------------------------
    #  VersionManager.resetObjVersion:
    #
    #  Resets work-version of object-attributes.
    # ---------------------------------------------------------------------------------------------
    def resetObjVersion(self):
      # States.
      self.__work_state__ = _globals.MyClass()
      # Versions.
      if len(self.objectValues(['ZMSAttributeContainer']))==0:
        req = {'lang':'*'}
        liveAttrCntnr = _zmsattributecontainer.manage_addZMSAttributeContainer(self)
        self.cloneObjAttrs(self,liveAttrCntnr,req)
        self.version_live_id = liveAttrCntnr.id
        workAttrCntnr = _zmsattributecontainer.manage_addZMSAttributeContainer(self)
        self.cloneObjAttrs(liveAttrCntnr,workAttrCntnr,req)
        self.version_work_id = workAttrCntnr.id


    # ---------------------------------------------------------------------------------------------
    #  VersionManager.isCommitted:
    #
    #  Checks if object can by displayed.
    # ---------------------------------------------------------------------------------------------
    def isCommitted(self, REQUEST):
      lang = REQUEST.get('lang',self.getPrimaryLanguage())
      preview = REQUEST.get('preview','') == 'preview'
      states = getObjStates(self)
      committed = False
      committed = committed or (not preview and not getObjStateName('STATE_NEW',lang) in states)
      committed = committed or (preview and not getObjStateName('STATE_DELETED',lang) in states)
      return committed


    """
    ###############################################################################################
    #  API object-state
    ###############################################################################################
    """

    # ---------------------------------------------------------------------------------------------
    #  VersionManager.setObjState:
    #
    #  Sets object-state.
    # ---------------------------------------------------------------------------------------------
    def setObjState(self, obj_state, lang):
      state = getObjStateName(obj_state,lang)
      states = getObjStates(self)
      if not state in states:
        states.append(state)
      self.__work_state__.states = copy.deepcopy(states)
      self.__work_state__ = copy.deepcopy(self.__work_state__)

    # ---------------------------------------------------------------------------------------------
    #  VersionManager.delObjStates:
    #
    #  Deletes object-state of this object.
    # ---------------------------------------------------------------------------------------------
    def delObjStates(self, obj_states=[], REQUEST={}):
      lang = REQUEST.get('lang',self.getPrimaryLanguage())
      states = getObjStates(self)
      for obj_state in obj_states:
        while obj_state in states:
          del states[states.index(obj_state)]
        while getObjStateName(obj_state,lang) in states:
          del states[states.index(getObjStateName(obj_state,lang))]
      self.__work_state__.states = copy.deepcopy(states)
      self.__work_state__ = copy.deepcopy(self.__work_state__)

    # ---------------------------------------------------------------------------------------------
    #  VersionManager.resetObjStates:
    #
    #  Resets object-state of this object.
    # ---------------------------------------------------------------------------------------------
    def resetObjStates(self, REQUEST):
      self.delObjStates( [ 'STATE_NEW', 'STATE_MODIFIED', 'STATE_DELETED'], REQUEST)

    # ---------------------------------------------------------------------------------------------
    #  VersionManager.inObjStates:
    #
    #  Checks if given states are in object-states of this object.
    # ---------------------------------------------------------------------------------------------
    def inObjStates(self, obj_states, REQUEST):
      states = getObjStates(self)
      states.extend(self.getObjStateNames(REQUEST))
      if len(states) > 0:
        lang = REQUEST.get('lang',self.getPrimaryLanguage())
        for obj_state in obj_states:
          obj_state_name = getObjStateName( obj_state, lang )
          if obj_state_name in states:
            return True
      return False

    # ---------------------------------------------------------------------------------------------
    #  VersionManager.getObjStateNames:
    #
    #  Returns a list of normalized object-states (language suffixes stripped off).
    # ---------------------------------------------------------------------------------------------
    def getObjStateNames(self, REQUEST):
      lang = REQUEST.get('lang')
      
      # Current Object.
      states = getObjStates(self)
      obj_states = []
      for obj_state in [ 'STATE_NEW', 'STATE_MODIFIED', 'STATE_DELETED']:
        obj_state_name = getObjStateName(obj_state,lang)
        if obj_state_name in states:
          obj_states.append(obj_state_name)
      
      # Return value.
      return obj_states


    """
    ###############################################################################################
    #  Change object-state.
    ###############################################################################################
    """

    # ---------------------------------------------------------------------------------------------
    #  VersionManager.setObjStateNew
    # ---------------------------------------------------------------------------------------------
    def setObjStateNew(self, REQUEST, reset=1):
      obj_state = 'STATE_NEW'
      if reset: self.resetObjVersion()
      setChangedBy( self, REQUEST)
      self.setObjState(obj_state,REQUEST['lang'])

    # ---------------------------------------------------------------------------------------------
    #  VersionManager.setObjStateModified
    # ---------------------------------------------------------------------------------------------
    def setObjStateModified(self, REQUEST):
      obj_state = 'STATE_MODIFIED'
      setChangedBy( self, REQUEST)
      self.setObjState(obj_state,REQUEST['lang'])

    # ---------------------------------------------------------------------------------------------
    #  VersionManager.setObjStateDeleted
    # ---------------------------------------------------------------------------------------------
    def setObjStateDeleted(self, REQUEST):
      obj_state = 'STATE_DELETED'
      setChangedBy( self, REQUEST)
      self.setObjState(obj_state,REQUEST['lang'])


    """
    ###############################################################################################
    #
    #   Commit
    #
    ###############################################################################################
    """

    # ---------------------------------------------------------------------------------------------
    #  VersionManager.onChangeObj:
    # ---------------------------------------------------------------------------------------------
    def onChangeObj(self, REQUEST, forced=0):
      lang = REQUEST.get('lang',self.getPrimaryLanguage())
      manage_lang = REQUEST.get('manage_lang',self.getManageLanguage(lang))
      
      ##### Trigger thumbnail generation of image fields ####
      _blobfields.thumbnailImageFields(self,lang,manage_lang,REQUEST)
      
      ##### Trigger custom onChangeObj-Event (if there is one) ####
      try: 
        if self.meta_type == 'ZMSCustom':
          metaObjAttr = self.getMetaobjAttr(self.meta_id,'onChangeObjEvt')
          if metaObjAttr is not None:
            try: REQUEST.set('preview','preview')
            except: REQUEST['preview'] = 'preview'
            v = self.getObjProperty('onChangeObjEvt',REQUEST)
      except:
        _globals.writeException(self,"[onChangeObj]: getObjProperty('onChangeObjEvt',REQUEST)")
      try: 
        if hasattr(self,'onChangeObjEvt'):
          try: REQUEST.set('preview','preview')
          except: REQUEST['preview'] = 'preview'
          v = getattr(self,'onChangeObjEvt')(context=self,REQUEST=REQUEST)
      except:
        _globals.writeException(self,"[onChangeObj]: onChangeObjEvt(self,REQUEST)")
      
      ##### Commit or initiate workflow transition ####
      if self.getAutocommit() or forced:
      	parent = self.getParentNode()
        self.commitObjChanges(parent,REQUEST,forced)
      else:
        self.autoWfTransition(REQUEST)


    # ---------------------------------------------------------------------------------------------
    #  VersionManager.onSynchronizeObj:
    # ---------------------------------------------------------------------------------------------
    def onSynchronizeObj(self, REQUEST):
      #-- Catalog
      self.synchronizeSearch(REQUEST)
      #-- Cache
      self.synchronizeCachePage(REQUEST)
      #-- Access
      self.synchronizePublicAccess()
      #-- References
      self.synchronizeRefToObjs()
      self.synchronizeRefByObjs()


    # ---------------------------------------------------------------------------------------------
    #  VersionManager.commitObjChanges
    # ---------------------------------------------------------------------------------------------
    def commitObjChanges(self, parent, REQUEST, forced=0):
      delete = False
      
      ##### Commit delete. ####
      # Self.
      if self.inObjStates(['STATE_DELETED'],REQUEST):
        parent.moveObjsToTrashcan([self.id], REQUEST)
        delete = True
      # Children.
      ids = [] 
      for child in self.getObjChildren('',REQUEST):
        if child.inObjStates(['STATE_DELETED'],REQUEST):
          ids.append(child.id)
      if len(ids) > 0:
        self.moveObjsToTrashcan(ids, REQUEST)

      ##### Commit modifications. ####
      if self.getObjStateNames(REQUEST) or forced:
        # Clone Live-Version to History-Version.
        if self.getConfProperty('ZMS.Version.active',0)==1 and \
           self.getObjProperty('change_dt',REQUEST) and \
           self.getObjProperty('change_uid',REQUEST):
          req = {'lang':'*'}
          workAttrCntnr = _zmsattributecontainer.manage_addZMSAttributeContainer(self)
          self.cloneObjAttrs(getattr(self,self.version_live_id),workAttrCntnr,req)
          self.setObjProperty( 'minor_version' ,self.getObjProperty( 'minor_version', REQUEST) + 1)
        # Clone Work-Version to Live-Version.
        self.cloneObjAttrs(getattr(self,self.version_work_id),getattr(self,self.version_live_id),REQUEST)
      # Special Objects / Link-Containers.
      children = []
      if self.meta_type == 'ZMSCustom' and (parent.meta_type == 'ZMSCustom' or not self.isPage()):
        children = self.getObjChildren('',REQUEST)
      elif self.meta_type == 'ZMSLinkContainer':
        children = self.getChildNodes(REQUEST,['ZMSLinkElement'])
      for child in children:
        child.commitObjChanges(self,REQUEST)
      
      ##### Reset object-state. ####
      self.resetObjStates(REQUEST)
      
      ##### Synchronize listeners. ####
      if not delete:
        self.onSynchronizeObj(REQUEST)
      
      # Return flag for deleted objects.
      return delete


    """
    ###############################################################################################
    #
    #   Rollback
    #
    ###############################################################################################
    """

    # ---------------------------------------------------------------------------------------------
    #  VersionManager.rollbackObjChanges
    # ---------------------------------------------------------------------------------------------
    def rollbackObjChanges(self, parent, REQUEST):
      delete = False
      
      ##### Rollback insert. ####
      # Self.
      if self.inObjStates(['STATE_NEW'],REQUEST):
        parent.moveObjsToTrashcan([self.id], REQUEST)
        delete = True
      # Children.
      ids = [] 
      for child in self.getObjChildren('',REQUEST):
        if child.inObjStates(['STATE_NEW'],REQUEST):
          ids.append(child.id)
      if len(ids) > 0:
        self.moveObjsToTrashcan(ids, REQUEST)
      
      ##### Rollback modifications. ####
      elif self.getObjStateNames(REQUEST):
        setChangedBy(self,REQUEST)
        self.cloneObjAttrs(getattr(self,self.version_live_id),getattr(self,self.version_work_id),REQUEST)
      
      # Special Objects / Link-Containers.
      children = []
      if self.meta_type == 'ZMSCustom' and (parent.meta_type == 'ZMSCustom' or not self.isPage()):
        children = self.getObjChildren('',REQUEST)
      elif self.meta_type == 'ZMSLinkContainer':
        children = self.getChildNodes(REQUEST,['ZMSLinkElement'])
      for child in children:
        child.rollbackObjChanges(self,REQUEST)
      
      ##### Reset object-state. ####
      self.resetObjStates(REQUEST)
      
      ##### Synchronize listeners. ####
      if not delete:
        self.onSynchronizeObj(REQUEST)
      
      # Return flag for deleted objects.
      return delete


    """
    ###############################################################################################
    #
    #   History
    #
    ###############################################################################################
    """

    # ---------------------------------------------------------------------------------------------
    #  VersionManager.getObjVersion:
    #
    #  Returns attribute-container. If Http-Request has key >ZMS_VERSION< the desired version 
    #  is returned, if Http-Request has key >preview< the work-version is returned, else the 
    #  live-version is returned.
    # ---------------------------------------------------------------------------------------------
    def getObjVersion(self, REQUEST={}):
      try:
        ob = None
        id = None
        if REQUEST.get('ZMS_VERSION',None) is not None:
          if REQUEST['ZMS_VERSION'].find(self.id+'/')==0:
            id = REQUEST['ZMS_VERSION'][len(self.id+'/'):]
        if id is None:
          if _globals.isPreviewRequest(REQUEST):
            id = self.version_work_id
          else:
            id = self.version_live_id
        ob = getattr(self,id)
        s = ob.id # Never delete this line!
        return ob
      except:
        raise _globals.writeException( self, '[getObjVersion]: an unexpected error occured!')


    # ---------------------------------------------------------------------------------------------
    #  VersionManager.getObjVersions:
    #
    #  Returns all attribute-containers.
    # ---------------------------------------------------------------------------------------------
    def getObjVersions(self, REQUEST={}):
      try:
        obj_state_names = self.getObjStateNames(REQUEST)
        obs = []
        lang = REQUEST.get('lang','*')
        for ob in self.objectValues(['ZMSAttributeContainer']):
          change_lang = ob.getObjProperty('change_lang',REQUEST)
          if (lang == '*') or \
             (lang != '*' and \
              ((len(obs)==0) or \
               (change_lang == lang) or \
               (change_lang == '' and lang==self.getPrimaryLanguage()))):
            if ob.id != self.version_work_id or len( obj_state_names) > 0:
              change_dt = ob.getObjProperty('change_dt',REQUEST)
              if change_dt is not None:
                obs.insert(0,(change_dt,ob))
        # sort object-items
        obs.sort()
        obs.reverse()
        # truncate sort-id from sorted object-items
        obs = map( lambda ob: ob[1], obs)
        # return object-items
        return obs
      except:
        raise _globals.writeException( self, '[getObjVersions]: an unexpected error occured!')


    # ---------------------------------------------------------------------------------------------
    #  VersionManager.run_pack_history:
    #
    #  Runs packing of history.
    # ---------------------------------------------------------------------------------------------
    def run_pack_history(self, forced=0):
      days = self.getConfProperty('ZMS.Version.autopack','')
      try:
        days = int(days)
      except:
        days = -1
      if days > 0:	
        now = time.time()
        last_run = self.getConfProperty('ZMS.Version.autopack.datetime',None)
        if forced or \
           last_run is None or \
           _globals.daysBetween(last_run,now) > 1:
          #-- Pack objects.
          if self.getConfProperty('ZMS.Version.active',0)==1:
            pack(self, days)
          #-- Update time-stamp.
          self.setConfProperty('ZMS.Version.autopack.datetime',time.localtime(time.time()))


    # ---------------------------------------------------------------------------------------------
    #  VersionManager.restoreAttributeContainer:
    #
    #  Restores attribute-container.
    # ---------------------------------------------------------------------------------------------
    def restoreAttributeContainer( self, id, REQUEST):
      attrCntnr = getattr(self,id,None)
      if attrCntnr is not None and \
         id != self.version_work_id:
        REQUEST.set('ZMS_VERSION',None)
        major_version = self.getObjProperty('major_version',REQUEST)
        minor_version = self.getObjProperty('minor_version',REQUEST)
        # Restore attributes.
        self.setObjStateModified(REQUEST)
        self.cloneObjAttrs(attrCntnr,getattr(self,self.version_work_id),REQUEST)
        setChangedBy(self,REQUEST)
        self.setObjProperty('major_version',major_version)
        self.setObjProperty('minor_version',minor_version)
        self.onChangeObj(REQUEST)
        return True
      return False


    ###############################################################################################
    #  VersionManager.manage_UndoVersion:
    #
    #  Undo version changes.
    ###############################################################################################
    manage_VersionLangModified = HTMLFile('dtml/versionmanager/manage_versionlangmodified', globals())
    manage_UndoVersionForm = HTMLFile('dtml/versionmanager/manage_undoversionform', globals())
    def manage_UndoVersion(self, lang, manage_lang, REQUEST):
      """ VersionManager.manage_UndoVersion """
      message = ''
      
      # Reset.
      # ------
      if REQUEST.get('btn','') == self.getLangStr('BTN_RESET',manage_lang):
        ids = REQUEST.get('ids',[])
        if len(ids) == 1:
          id = ids[0]
          REQUEST.set('ZMS_VERSION',id)
          change_dt = self.getObjProperty('change_dt',REQUEST)
          if self.restoreAttributeContainer( id, REQUEST):
            # Restore children.
            if REQUEST.get( 'pageelements') == '1':
              for ob in self.getObjChildren( '', REQUEST, self.PAGEELEMENTS):
                reset_ob_version = False
                for ob_version in ob.getObjVersions(REQUEST):
                  if not reset_ob_version:
                    REQUEST.set('ZMS_VERSION',ob.id+'/'+ob_version.id)
                    if ob.getObjProperty('change_dt',REQUEST)<=change_dt:
                      reset_ob_version = ob.restoreAttributeContainer( ob_version.id, REQUEST)
                if not reset_ob_version:
                  self.manage_deleteObjs( lang, manage_lang, ids=[ob.id], REQUEST=REQUEST)
            # Restore sort-order.
            parent = self.getParentNode()
            if parent is not None: 
              parent.normalizeSortIds(_globals.id_prefix(self.id))
            message = self.getLangStr('MSG_CHANGED',manage_lang)

      # Return with message.
      message = urllib.quote(message)
      return REQUEST.RESPONSE.redirect('manage_UndoVersionForm?lang=%s&manage_lang=%s&manage_tabs_message=%s'%(lang,manage_lang,message))


###################################################################################################
###################################################################################################
###
###   class VersionManagerContainer
###
###################################################################################################
###################################################################################################
class VersionManagerContainer: 

    """
    ###############################################################################################
    #  Notification
    ###############################################################################################
    """

    # ---------------------------------------------------------------------------------------------
    #  WorkflowContainer.getRecipientWf
    # ---------------------------------------------------------------------------------------------
    def getRecipientWf(self, REQUEST=None):
      recipient = ''
      name = self.getObjProperty('work_uid',REQUEST)
      mto = self.getUserAttr(name,'email','')
      if len(mto) > 0:
        recipient = name + ' <' + mto + '>'
      return recipient
    
    # ---------------------------------------------------------------------------------------------
    #  WorkflowContainer.getRecipientsByRole
    # ---------------------------------------------------------------------------------------------
    def getRecipientsByRole(self, roles=['ZMSEditor'], REQUEST=None):
      recipients = ''
      langs = [REQUEST['lang']]
      ob = self
      while ob is not None and len(recipients) == 0:
        for local_role in ob.get_local_roles():
          name = local_role[0]
          userObj = self.findUser(name)
          mto = self.getUserAttr(name,'email','')
          if userObj is not None and \
	     len(mto) > 0 and \
             len(self.intersection_list(roles, ob.getUserRoles(userObj, aq_parent=0))) > 0 and \
             len(self.intersection_list(langs, ob.getUserLangs(userObj, aq_parent=0))) > 0:
            if len(recipients) > 0:
              recipients += ', '
            recipients += name + ' <' + mto + '>'
        ob = ob.getParentNode()
      return recipients

    """
    ###############################################################################################
    #  Workflow
    ###############################################################################################
    """

    # ---------------------------------------------------------------------------------------------
    #  WorkflowContainer.resetWfStates:
    #
    #  Resets information about workflow-events.
    # ---------------------------------------------------------------------------------------------
    def resetWfStates(self, REQUEST):
      lang = REQUEST['lang']
      self.delObjStates(self.getWfActivitiesIds(), REQUEST)
      self.autoWfTransition(REQUEST)

    # ---------------------------------------------------------------------------------------------
    #  WorkflowContainer.autoWfTransition
    # ---------------------------------------------------------------------------------------------
    def autoWfTransition(self, REQUEST):
      lang = REQUEST['lang']
      # Special Objects.
      parent = self.getParentNode()
      if (self.meta_type == 'ZMSLinkContainer') or \
         (self.meta_type == 'ZMSCustom' and (parent.meta_type == 'ZMSCustom' or not self.isPage())):
        parent.autoWfTransition(REQUEST)
        return
      # Enter Workflow.
      enter = len(self.getWfStates(REQUEST)) == 0
      modified = self.isObjModified(REQUEST) or self.hasObjModifiedChildren(REQUEST)
      if not enter:
        wfStates = self.getWfStates(REQUEST)
        for wfTransition in self.getWfTransitions():
          enter = enter or \
             (len(self.intersection_list(wfStates, wfTransition.get('from',[]))) > 0 and \
              len(wfTransition.get('to',[])) == 0)
          if enter:
            break
      if enter and modified:
        for wfTransition in self.getWfTransitions():
          if len(wfTransition.get('from',[])) == 0 and \
             len(wfTransition.get('to',[])) > 0:
            if _globals.debug( self): 
              _globals.writeLog( self, "[autoWfTransition]: name=%s, id=%s"%(wfTransition['name'],wfTransition['id']))
            # Delete old state.
            self.delObjStates(self.getWfStates(REQUEST), REQUEST)
            # Add new state.
            self.setObjState(wfTransition.get('to',[])[0], lang)
            # Set Properties.
            self.setObjProperty('work_uid',str(REQUEST.get('AUTHENTICATED_USER')),lang)
            self.setObjProperty('work_dt',time.time(),lang)
            break
      elif not enter and not modified:
        # Delete old state.
        self.delObjStates(self.getWfStates(REQUEST), REQUEST)


    ###############################################################################################
    #  WorkflowContainer.manage_wfTransition:
    #
    #  Workflow transition.
    ###############################################################################################
    def manage_wfTransition(self, lang, manage_lang, custom, REQUEST, RESPONSE):
      """ WorkflowContainer.manage_wfTransition """
      wfTransitions = self.getWfTransitions()
      for wfTransition in filter(lambda x: x['name']==custom, wfTransitions):
        dtml = wfTransition.get('dtml','')
        if len(dtml) > 0:
	  return _globals.dt_html(self, dtml, REQUEST) 
	else:
	  return self.manage_wfTransitionFinalize(lang, manage_lang, custom, REQUEST, RESPONSE)


    ###############################################################################################
    #  WorkflowContainer.manage_wfTransitionFinalize:
    #
    #  Workflow transition finalize.
    ###############################################################################################
    def manage_wfTransitionFinalize(self, lang, manage_lang, custom, REQUEST, RESPONSE=None):
      """ WorkflowContainer.manage_wfTransitionFinalize """
      url = ''
      message = ''
      wfTransitions = self.getWfTransitions()
      for wfTransition in filter(lambda x: x['name']==custom, wfTransitions):
        # Delete old state.
        self.delObjStates(self.getWfStates(REQUEST), REQUEST)
        # Add new state.
        for wfState in wfTransition.get('to',[]):
          if _globals.debug( self): 
            _globals.writeLog( self, "[manage_wfTransition]: Add %s"%wfState)
          self.setObjState(wfState, lang)
          message += REQUEST.get('manage_tabs_message', filter(lambda x: x['id']==wfState,self.getWfActivities())[0]['name'])
        # Set Properties.
	work_dt = time.time()
	work_uid = str(REQUEST.get('AUTHENTICATED_USER'))
	work_desc = REQUEST.get('work_desc','')
        self.setObjProperty('work_dt',work_dt,lang)
        self.setObjProperty('work_uid',work_uid,lang)
        # Log Protocol.
        log = ''
        log = log + self.getLangFmtDate(work_dt,lang,'%Y-%m-%d %H:%M:%S') + '\t'
        log = log + wfTransition['id'] + '\t'
        log = log + self.absolute_url()[len(self.getHome().absolute_url()):] + '\t'
        log = log + self.display_type(REQUEST) + '\t'
        log = log + work_uid + '\t'
        log = log + work_desc
        _workflowmanager.writeProtocol(self, log)
      self.autoWfTransition(REQUEST)
      # Return with message.
      if RESPONSE is not None:
        return RESPONSE.redirect('%s/manage_main?lang=%s&manage_lang=%s&manage_tabs_message=%s'%(self.absolute_url(),lang,manage_lang,message))


    """
    ###############################################################################################    
    #  Tasks 
    ###############################################################################################    
    """

    # Management Interface.
    # ---------------------
    manage_tasks = HTMLFile('dtml/versionmanager/manage_tasks', globals()) 
    task_wf = HTMLFile('dtml/versionmanager/tasklist0', globals()) 
    task_zmsnote = HTMLFile('dtml/versionmanager/tasklist1', globals()) 
    task_untranslated = HTMLFile('dtml/versionmanager/tasklist2', globals()) 
    task_changed_by_date = HTMLFile('dtml/versionmanager/tasklist3', globals()) 


    """
    ###############################################################################################
    #  Commit
    ###############################################################################################
    """

    # ---------------------------------------------------------------------------------------------
    #  VersionManagerContainer.commitObj:
    #
    #  Commit container.
    # ---------------------------------------------------------------------------------------------
    def commitObj(self, REQUEST={}):
      if _globals.debug( self): 
        _globals.writeLog( self, "[commitObj]")
      ##### Version ####
      if self.getConfProperty('ZMS.Version.active',0)==1 and \
         not self.isObjModified( REQUEST) and self.hasObjModifiedChildren( REQUEST):
        self.setObjStateModified( REQUEST)
      ##### Children ####
      delete = 0
      for child in self.getChildNodes():
        delete = delete + child.commitObjChanges(self,REQUEST)
      ##### Self ####
      if REQUEST.has_key('lang'): 
        self.resetWfStates(REQUEST)
      parent = self.getParentNode()
      delete = self.commitObjChanges(parent,REQUEST)
      url = self.absolute_url()
      if delete: 
        url = parent.absolute_url()
      # Return new URL.
      return url


    """
    ###############################################################################################
    #  Rollback
    ###############################################################################################
    """

    # ---------------------------------------------------------------------------------------------
    #  VersionManagerContainer.rollbackObj
    # ---------------------------------------------------------------------------------------------
    def rollbackObj(self, REQUEST):
      if _globals.debug( self): 
        _globals.writeLog( self, "[rollbackObj]")
      ##### Children ####
      delete = 0
      for child in self.getChildNodes():
        delete = delete + child.rollbackObjChanges(self,REQUEST)
      ##### Self ####
      if REQUEST.has_key('lang'): self.resetWfStates(REQUEST)
      parent = self.getParentNode()
      delete = self.rollbackObjChanges(parent,REQUEST)
      url = self.absolute_url()
      if delete: 
        url = parent.absolute_url()
      # Return new URL.
      return url

###################################################################################################