#######################
# (c) Jan Walter 2000 #
#######################

# CVS
# $Author: jan $
# $Date: 2001/02/06 19:20:14 $
# $RCSfile: wrlexport.py,v $
# $Revision: 1.4 $

import Blender
import string

class VrmlExport:
    def __init__(self, filename):
        self.file = open(filename, "w")

    def export(self, scene):
        print "exporting ..."
        self.writeHeader()
        for name in scene.objects:
            object = Blender.getObject(name)
            if object.type == "Mesh":
                mesh = Blender.getMesh(object.data)
                self.file.write("    Transform {\n")
                self.file.write("      children [\n")
                self.writeIndexedFaceSet(name, object, mesh, normals = 0)
                if mesh.normals:
                    self.writeIndexedFaceSet(name, object, mesh, normals = 1)
                self.file.write("      ]\n")
                self.file.write("    }\n")
        self.writeEnd()

    def writeEnd(self):
        self.file.write("  ]\n")
        self.file.write("}\n")
        self.file.close()
        print "... finished"

    def writeHeader(self):
        self.file.write("#VRML V2.0 utf8\n\n")
        self.file.write("Transform {\n")
        self.file.write("  children [\n")

    def writeIndexedFaceSet(self, name, object, mesh, normals = 0):
        newName = string.replace(name, ".", "_")
        newName = string.replace(newName, " ", "_")
        self.file.write("        DEF %s%s Shape {\n" %
                        (string.upper(newName), normals))
        self.file.write("          appearance Appearance {\n")
        self.file.write("            material Material {\n")
        self.file.write("            }\n")
        self.file.write("          }\n")
        self.file.write("          geometry IndexedFaceSet {\n")
        # vertices
        self.file.write("            coord Coordinate {\n")
        self.file.write("              point [\n")
        for vertex in mesh.vertices[:-1]:
            self.file.write("                %s %s %s,\n" %
                            (vertex[0], vertex[1], vertex[2]))
        vertex = mesh.vertices[-1]
        self.file.write("                %s %s %s\n" %
                        (vertex[0], vertex[1], vertex[2]))
        self.file.write("              ]\n")
        self.file.write("            }\n")
        self.file.write("            coordIndex [\n")
        for face in mesh.faces[:-1]:
            if face[2] != 0:
                if face[3] == 0 and face[4] == normals:
                    # triangle
                    self.file.write("              %s, %s, %s" %
                                    (face[0], face[1], face[2]) +
                                    ", -1,\n")
                elif face[3] != 0 and face[4] == normals:
                    # quad
                    self.file.write("              %s, %s, %s, %s" %
                                    (face[0], face[1],
                                     face[2], face[3]) +
                                    ", -1,\n")
        face = mesh.faces[-1]
        if face[2] != 0:
            if face[3] == 0 and face[4] == normals:
                # triangle
                self.file.write("              %s, %s, %s" %
                                (face[0], face[1], face[2]) +
                                "\n")
            elif face[3] != 0 and face[4] == normals:
                # quad
                self.file.write("              %s, %s, %s, %s" %
                                (face[0], face[1],
                                 face[2], face[3]) +
                                "\n")
        self.file.write("            ]\n")
        # colors
        if mesh.colors:
            # vertex colors
            print "vertex colors should be used ..."
        else:
            # face colors
            self.file.write("            color Color {\n")
            self.file.write("              color [\n")
            last = len(object.materials) - 1
            for index in xrange(len(object.materials)):
                name = object.materials[index]
                material = Blender.getMaterial(name)
                if index == last:
                    self.file.write("                %s %s %s\n" %
                                    (material.R, material.G, material.B))
                else:
                    self.file.write("                %s %s %s,\n" %
                                    (material.R, material.G, material.B))
            self.file.write("              ]\n")
            self.file.write("            }\n")
            self.file.write("            colorIndex [\n")
            for face in mesh.faces[:-1]:
                if face[2] != 0 and face[4] == normals:
                    self.file.write("              %s,\n" % face[5])
            face = mesh.faces[-1]
            self.file.write("              %s\n" % face[5])
            self.file.write("            ]\n")
            self.file.write("            colorPerVertex FALSE\n")
        # normals
        if normals and mesh.normals:
            self.file.write("            normal Normal {\n")
            self.file.write("              vector [\n")
            for normal in mesh.normals[:-1]:
                self.file.write("                %s, %s, %s,\n" %
                    (normal[0], normal[1], normal[2]))
            normal = mesh.normals[-1]
            self.file.write("                %s %s %s\n" %
                            (normal[0], normal[1], normal[2]))
            self.file.write("              ]\n")
            self.file.write("            }\n")
        self.file.write("          }\n")
        self.file.write("        }\n")

wrlexport = VrmlExport("test.wrl")
scene = Blender.getCurrentScene()
wrlexport.export(scene)
