/****************************************************************************
**
** Copyright (C) 2002-2006 Frank Hemer <frank@hemer.org>,
**                         Tilo Riemer <riemer@crossvc.com>,
**                         Jose Hernandez <joseh@tesco.net>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** CrossVC is available under two different licenses:
**
** If CrossVC is linked against the GPLed version of Qt 
** CrossVC is released under the terms of GPL also.
**
** If CrossVC is linked against a nonGPLed version of Qt 
** CrossVC is released under the terms of the 
** CrossVC License for non-Unix platforms (CLNU)
**
**
** CrossVC License for non-Unix platforms (CLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than CrossVC.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** CrossVC License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation, version 2 of the License.
** This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License version 2 for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#ifndef SETTINGSDIALOGIMPL_H
#define SETTINGSDIALOGIMPL_H

//----------------------------------------------------------------------------

#include "config.h"

//----------------------------------------------------------------------------

#include <qcolor.h>
#include <qiconset.h>

//----------------------------------------------------------------------------

#include "settingsdialog.h"

//----------------------------------------------------------------------------

class QPushButton;

//----------------------------------------------------------------------------

class SettingsDialogImpl : public SettingsDialog
{ 
   Q_OBJECT

 public:
   SettingsDialogImpl(const QIconSet &, QWidget* parent = 0, const char* name = 0,
	 bool modal = FALSE, WFlags fl = 0);
   ~SettingsDialogImpl();

   bool isOnTheFlyScanningModeChanged();
   bool isAgentSetupChanged();

 signals:
   void setFonts();
   void autoUpdateStateChanged();
   void refreshEntries();
   void createCommitDlg();
   
 public slots:
   void loadTemplateFromFile();
   void setIconDir();
   void browseCvsPath();
   void browseCvsPassFile();
   void cvsVersionChecked(int);

   void addProxy();
   void modifyProxy();
   void removeProxy();

   void showColorDlgFileA();
   void showColorDlgFileB();
   void showColorDlgQuestionMark();
   void showColorDlgModified();
   void showColorDlgNeedsUpdate();
   void showColorDlgMerging();
   void showColorDlgConflict();
   void showColorDlgAdded();
   void showColorDlgRemoved();
   void showColorDlgRemovedByOther();
   void showColorDlgDiffOld();
   void showColorDlgDiffNew();

   void browseSshAgentCmd();
   void browseLocalBrowserCmd();
   void browseLocalShellCmd();
   void browseRemoteBrowserCmd();
   void browseRemoteShellCmd();
   void browseExternalDiffCmd();
   void maintainKeyClicked();

   void chooseFontGeneral();
   void chooseFontMessage();
   void chooseFontDiff();
   void fontUseDefaultToggled(bool);
   void fontMessageUseGeneralToggled(bool);
   void fontDiffUseGeneralToggled(bool);

   void enterWhatsThisMode();

      
 protected slots:
   void accept();
   void apply();
   void selectionChanged(QListBoxItem* item);

   
 private:

   QColor showColorDlg(QColor curColor, CColorButton* pBtn);
   void fillLangEnv();
   void applyLangEnv();
   
   bool m_onTheFlyScanningModeChanged;
   bool m_agentSetupChanged;
   bool m_dialogUp;
   QStringList m_sshKeyFiles;

   QColor m_colorFileA;
   QColor m_colorFileB;
   QColor m_questionMark;
   QColor m_modified;
   QColor m_needsUpdate;
   QColor m_merging;
   QColor m_conflict;
   QColor m_added;
   QColor m_removed;
   QColor m_removedByOther;
   QColor m_diffOld;
   QColor m_diffNew;
};

//----------------------------------------------------------------------------

#endif // SETTINGSDIALOGIMPL_H

