
/*
 * LOGIT.C
 *
 */

#include "defs.h"

Prototype void LogIncoming(const char *format, char *label, const char *msgid, char *err);
Prototype void CloseIncomingLog(void);

FILE	*LIFd = NULL;
time_t	LINextCheck = 0;
int	LIUseSyslog = 0;
int	LIDisabled  = 0;
int	LILastInode = 0;

void
LogIncoming(const char *format, char *label, const char *msgid, char *err)
{
    const char *LIFname;
    struct stat st;

    if ((!LIFd && !LIUseSyslog && !LIDisabled) || (time(NULL) > LINextCheck)) {
	LINextCheck = time(NULL) + 10;
	if (strcmp(IncomingLogPat, "SYSLOG") == 0) {
	    LIUseSyslog = 1;
	} else if (strcmp(IncomingLogPat, "NONE") == 0) {
	    LIDisabled = 1;
	} else {
	    LIFname = PatLogExpand(IncomingLogPat);
	    if (stat(LIFname, &st) != 0)
		LILastInode = 0;
	    if (!LIFd || !LILastInode || (LILastInode != st.st_ino)) {
		/* Need to reopen the log file */
		if (LIFd)
		    fclose(LIFd);
		LIFd = fopen(LIFname, "a");
		if (stat(LIFname, &st) == 0)
		    LILastInode = st.st_ino;
	    }
	    if (LIFd == NULL)
	        LIUseSyslog = 1;
	}
    }

    /* print message itself */
    if (LIUseSyslog) {
	logit(LOG_INFO, format, label, msgid, err);
    } else if (LIDisabled) {
	/* Do nothing. */
    } else {
	char newformat[512];

	/* Add date and time. Syslog has its own time stamps. */
	strcpy(newformat, "%s ");
	strcat(newformat, format);
	fprintf(LIFd, newformat, LogTime(), label, msgid, err);
	fflush(LIFd);
    }
}

void
CloseIncomingLog(void)
{
    if (LIFd != NULL) {
	fclose(LIFd);
	LIFd = NULL;
    }
}
