#include "main.h"

/****************************************************************
  GET_RESOLVE_FILE
  *****************************************************************/
/** builds a default resole file based on the host which is being used */
/*  to build the system                                */

void get_resolve_file()
{
       
       FILE* outfd;
       char *new_def_cell,
       *name1,
       *name2,
       *name3,
       *name4,
       *choice,
       *fq_hostname;
       char *rh,*rp;

       int cont=1 ;
       int first_one=1;

       MALLOC_STR(rh);
       MALLOC_STR(rp);
       MALLOC_STR(default_cell);


       printf("\n\n\n##################################################\n");
       printf("Configuring the resolve_file....last thing...Note this \n");
       printf("Could take a few seconds....\n\n\n\n");

       get_res_ports(rh,rp,default_cell); 

       MALLOC_STR(default_host);
       bzero(default_host,MAXLEN);

       if( strcmp(rp,rh) != 0){
	      printf("\n\n#######Warning host name does not == peer name\n");
	      strcpy(default_host,rp);
       }
       else
       {
	      strcpy(default_host,"NONE");

       }
       printf("resolve_file configured as follows\n");
       printf("%s %s %s NONE NONE\n",default_cell,rh,rp);

       if(!(outfd = fopen("../SRC/resolve_file","w"))) {
	    err_crit("Can't open ../SRC/resolve_file for writing\n");
       }

       fprintf(outfd,"%s\n","# NOTE! blank lines NOT permitted #");
       fprintf(outfd,"%s\n","# NOTE! fields must be separated by one(1) AND ONLY one space #");

       fprintf(outfd,"%s\n","# 1st field = cell_name");
       fprintf(outfd,"%s\n","# 2nd field = primary qmaster");
       fprintf(outfd,"%s\n","# 3rd field = primary qmaster alias");
       fprintf(outfd,"%s\n","# 4th field = secondary qmaster");
       fprintf(outfd,"%s\n","# 5th field = secondary qmaster alias");
       fprintf(outfd,"%s %s %s NONE NONE\n",default_cell,rh,rp);

       
       fclose(outfd);
       chmod(resolve_file,0644);

}





