#include "def.h"
#include <signal.h>
#include <stdio.h>

struct sigaction sigusr1_vec,  sigusr1_ovec;
struct sigaction sigusr2_vec,  sigusr2_ovec;

FILE *fp;
int ckpt_count;

#ifdef sun
#define TRAILING_
#endif

#if ( defined (solaris) || defined (SOLARIS23_UP) )
#define TRAILING_
#endif

/************************************************************************************/

void sigusr1()
     
{
  
#ifdef TRAILING_
  dqs_migrate_();
#else
  dqs_migrate();
#endif
  exit(77); /* this exit value will be used */
  
}

/************************************************************************************/

void sigusr2()
     
{
  
#ifdef TRAILING_
  dqs_die_();
#else
  dqs_die();
#endif
  exit(78); /* this exit value will be used */
  
}

/************************************************************************************/

#ifdef TRAILING_
dqs_setup_ckpt_()
#else
     dqs_setup_ckpt()
#endif
     
{
  
  sigusr1_vec.sa_handler=sigusr1;
  sigfillset(&sigusr1_vec.sa_mask);
  sigdelset(&sigusr1_vec.sa_mask,SIGQUIT);
  sigusr1_vec.sa_flags=0;
  sigaction(SIGQUIT,&sigusr1_vec,&sigusr1_ovec);
  
  sigusr2_vec.sa_handler=sigusr2;
  sigfillset(&sigusr2_vec.sa_mask);
  sigdelset(&sigusr2_vec.sa_mask,SIGQUIT);
  sigusr2_vec.sa_flags=0;
  sigaction(SIGUSR2,&sigusr2_vec,&sigusr2_ovec);
  
}

