static char     user_rcsid[] = "$Id";
/***********************************************************
 * globals.h - include file for qmon
 *
 * Version 3.3 by Jeff Snyder
 * Date: 6/24/92
 *
 * Versions 3.4 & 3.5 by Lakhamraju R. Raju
 * Date: 11/02/93
 *
 * Major modifications: Removed motif calls and replaced 
 *	               with athena widget set calls.
 *
 * Copyright 1992, 1993, 1994
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *  user.c,v
 * Revision 1.2  1994/11/28  16:56:21  kerce
 * *** empty log message ***
 *
 * Revision 1.4  1994/09/13  18:03:59  raju
 * *** empty log message ***
 *
 * Revision 1.3  1994/08/21  03:00:05  raju
 * *** empty log message ***
 *
 *
 **********************************************************/
#include "globals.h"

static Widget           user_popup;
static Widget           widget_userrc;
static Widget           widget_userlabel;
static Widget           widget_userframe;
static Widget           widget_usermenu;
static Widget           widget_usermain;
static Widget           widget_userexec;
static Widget           widget_userclear;
static Widget           widget_userclose;
static Widget           widget_userseparator;
static Widget           widget_useropt;

struct optionstruct usermenu[]={
  0,"Cell          ","-cell",MENUTYPE,NULL,NULL,
  0,"Add              ","-au",ACTIONTYPE,NULL,NULL,
  0,"Delete           ","-du",ACTIONTYPE,NULL,NULL,
  0,"Show User In List","-su",ACTIONTYPE,NULL,NULL,
  0,"User Name     ",NULL,MENUTYPE,NULL,NULL,
  0,"List Name     ",NULL,MENUTYPE,NULL,NULL,
  0,"Show Users List  ","-sul",ACTIONTYPE,NULL,NULL,
  0,NULL,NULL,(int)NULL,NULL,NULL
};


/***********************************************************
 * pb_userexec - Activate callback for exec
 */
XtCallbackProc pb_userexec(Widget w, caddr_t client_data, caddr_t call_data)
{
  char          command[MAX_STRING_SIZE];
  
  sprintf(command,"%s -cell %s",QCONF_BINARY,current_cell);
  buildcommand(command,usermenu,0);
}


/***********************************************************
 * pb_userclear - Activate callback for clear
 */
XtCallbackProc pb_userclear(Widget w, caddr_t client_data, caddr_t call_data)
{
  int ii;
  Arg args[5];

  clearsubmenu(usermenu);
  QmonTextSetString(usermenu[0].widgetid ,current_cell );
  if(user_list) 
  	QmonTextSetString(usermenu[4].widgetid ,current_user );
  if(account_list) 
  	QmonTextSetString(usermenu[5].widgetid ,current_account );
}


/***********************************************************
 * pb_userclose - Activate callback for close
 */
XtCallbackProc pb_userclose(Widget w, caddr_t client_data, caddr_t call_data)
{
  closesubmenuwin();
}


/***********************************************************
 * useraction - Activate callback for action type menu
 */
XtCallbackProc useraction(Widget w, caddr_t client_data, caddr_t call_data)
{
  int             ii;
  char            command[MAX_STRING_SIZE];
  char            *ptr=NULL;
  char            *ptr1=NULL;
  char            *ptr2=NULL;

  ptr=QmonTextGetString(usermenu[4].widgetid);
  ptr1=QmonTextGetString(usermenu[5].widgetid);
  ptr2=QmonTextGetString(usermenu[0].widgetid);

  if(w==usermenu[1].widgetid ) {
    sprintf(command,"%s -cell %s %s %s %s &",QCONF_BINARY,ptr2,usermenu[1].flag,ptr,ptr1);
  }
  else if(w==usermenu[2].widgetid) {
    sprintf(command,"%s -cell %s %s %s %s &",QCONF_BINARY,ptr2,usermenu[2].flag,ptr,ptr1);
  }
  else if(w==usermenu[3].widgetid) {
      sprintf(command,"%s -cell %s %s %s &",QCONF_BINARY,ptr2,usermenu[3].flag,ptr1);
  }
  else if(w==usermenu[6].widgetid) {
    sprintf(command,"%s -cell %s %s &",QCONF_BINARY,ptr2,usermenu[6].flag);
  }

  execit(command);
}

/***********************************************************
 * create_user_dialog - Create widgets used for the user menu
 */
int create_user_dialog(Widget w,XtPointer client_data, XtPointer call_data)
{
  int         ii;
  Arg         args[32];
  Widget      user_form;
  Position    x, y;
  Dimension   width, height;
  Widget      exec,clear,close;

  usermenu[0].list = cell_list;
  usermenu[4].list = user_list;
  usermenu[5].list = account_list;

  ii = 0;
  XtSetArg(args[0], XtNwidth, &width); ii++;
  XtSetArg(args[1], XtNheight, &height); ii++;
  XtGetValues(w, args, ii);
  XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2),
                    &x, &y);
  ii = 0;
  XtSetArg(args[ii], XtNx, x);                         ii++;
  XtSetArg(args[ii], XtNy, y);                         ii++;

  user_popup = XtCreatePopupShell("userpop", transientShellWidgetClass, w,
                             args, ii);
  ii = 0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  user_form = XtCreateManagedWidget("form", formWidgetClass, user_popup,args,
ii);

  ii=0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  widget_userlabel=
        XtCreateManagedWidget("Configure User",labelWidgetClass,user_form,args
,ii);

  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_userlabel); ii++;
  widget_usermain=XtCreateManagedWidget("box",formWidgetClass,user_form,
                                        args,ii);

/*
 exec=QmonAddButtonN(widget_usermain,NULL,"Exec",(XtCallbackProc)pb_userexec,NULL);
*/
 clear=QmonAddButtonN(widget_usermain,NULL,"Reset",(XtCallbackProc)pb_userclear,NULL);
 close=QmonAddButtonN(widget_usermain,clear,"Close",(XtCallbackProc)pb_userclose,NULL);

widget_useropt=createmenuoptions(user_form,widget_usermain,usermenu,(XtCallbackProc)useraction);
  
}


/***********************************************************
 * openwidget_usersub - Open the user menu
 */
int openwidget_usersub()
{
  pb_userclear(NULL,NULL,NULL);
  XtPopup(user_popup,XtGrabNone);
}


/***********************************************************
 * closewidget_usersub - Close the user menu
 */
int closewidget_usersub()
{
  XtPopdown(user_popup);
}
