/* Copyright (c) 1996--1999 Geoff Pike. */
/* All rights reserved. */

/* Floater is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. */

/* This software is provided "as is" and comes with absolutely no */
/* warranties.  Geoff Pike is not liable for damages under any */
/* circumstances.  Support is not provided.  Use at your own risk. */

/* Personal, non-commercial use is allowed.  Attempting to make money */
/* from Floater or products or code derived from Floater is not allowed */
/* without prior written consent from Geoff Pike.  Anything that remotely */
/* involves commercialism, including (but not limited to) systems that */
/* show advertisements while being used and systems that collect */
/* information on users that is later sold or traded require prior */
/* written consent from Geoff Pike. */
#include "floater.h"

stringlist *member(char *s, stringlist *l)
{
  while (l != NULL) if (streq(s, l->s)) return l; else l = l->next;
  return NULL;
}

/* free a node; return the contents of its `next' pointer */
/* (somewhat misnamed---perhaps freestringlistnode would be better) */
stringlist *freestringlist(stringlist *l)
{
  stringlist *ret;

  assert(l != NULL);
  ret = l->next;
  free(l->s);
  free(l);
  return ret; 
}

/* adjoin */
stringlist *addstringlist(char *s, stringlist *who)
{
  stringlist *l;

  if (member(s, who)) return who;

  l = alloc(stringlist);
  l->s = STRDUP(s);
  l->next = who;
  return l;
}

/* add s on the front without copying it or checking for its presence in who */
stringlist *consstringlist(char *s, stringlist *who)
{
  stringlist *l;

  l = alloc(stringlist);
  l->s = s;
  l->next = who;
  return l;
}

/* remove first occurrence of s, return the resulting list */
stringlist *removestringlist(char *s, stringlist *who)
{
  stringlist *l;

  if (who == NULL) return NULL;

  if (streq(who->s, s)) return freestringlist(who);

  for (l=who; l->next != NULL; l = l->next)
    if (streq(l->next->s, s)) {
      l->next = freestringlist(l->next);
      return who;
    }

  return who;
}

int length(stringlist *l)
{
  int i;

  for (i = 0; l != NULL; l = l->next) i++;
  return i;
}
