/* Copyright (c) 1996--1999 Geoff Pike. */
/* All rights reserved. */

/* Floater is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. */

/* This software is provided "as is" and comes with absolutely no */
/* warranties.  Geoff Pike is not liable for damages under any */
/* circumstances.  Support is not provided.  Use at your own risk. */

/* Personal, non-commercial use is allowed.  Attempting to make money */
/* from Floater or products or code derived from Floater is not allowed */
/* without prior written consent from Geoff Pike.  Anything that remotely */
/* involves commercialism, including (but not limited to) systems that */
/* show advertisements while being used and systems that collect */
/* information on users that is later sold or traded require prior */
/* written consent from Geoff Pike. */
/////////////////////////////////////////////////////////////////////////////
// Separation of the talk window
/////////////////////////////////////////////////////////////////////////////

proc copytext {old new} {
    global talktext

    set talktext $new
    catch {$new insert end [$old get 0.0 end-1c]}
}

set separateTalk_ [set talk_is_sep 0]
proc separateTalk {{toggle 0}} {
    global talk_is_sep talkfont separateTalk_

    // catch {talkmsg "separateTalk $toggle with talk_is_sep=$talk_is_sep separateTalk_=$separateTalk_"}
    if $toggle {set separateTalk_ [expr !$separateTalk_]}
    if {$talk_is_sep == $separateTalk_} return
    if [set talk_is_sep $separateTalk_] {
	catch {destroy .floaterTalk}
	toplevel .floaterTalk
	wm title .floaterTalk "Floater Talk"
	text .floaterTalk.text -wrap word -font $talkfont -relief raised -yscrollcommand ".floaterTalk.scroll set"
	pack [scrollbar .floaterTalk.scroll -command ".floaterTalk.text yview"] -side right -fill y
	pack .floaterTalk.text -side left -fill both -expand yes
	copytext .talk.text .floaterTalk.text
	.talk.text delete 0.0 end
	pack forget .talk
	.floaterTalk.text yview -pickplace end
	bind .floaterTalk.text <Configure> \
		{.floaterTalk.text yview -pickplace end}
	bind .floaterTalk.text <FocusIn> focus_cmdline
    } else {
	copytext .floaterTalk.text .talk.text
	catch {destroy .floaterTalk}
	pack .talk
    }
}	

// if {$effectiveheight < 500} {after 1000 separateTalk 1}

/////////////////////////////////////////////////////////////////////////////

set hideMatrix_ [set matrix_hidden_during_auction 0]
proc hideMatrix {{toggle 0}} {
    global hideMatrix_ matrix_hidden_during_auction needAuctionUpdate

    // catch {talkmsg "hideMatrix $toggle with matrix_hidden_during_auction=$matrix_hidden_during_auction hideMatrix_=$hideMatrix_"}
    if $toggle {set hideMatrix_ [expr !$hideMatrix_]}
    if {$hideMatrix_ == $matrix_hidden_during_auction} return
    set matrix_hidden_during_auction $hideMatrix_
    set needAuctionUpdate 1
}

// Default on a small screen is to hide the matrix during the auction.
if {$effectiveheight < 770} {hideMatrix 1}

set matrix_showing 1
proc showMatrix {b} {
    global matrix_showing canv

    // catch {talkmsg "showMatrix $b"}
    if {$b == $matrix_showing} return
    if [set matrix_showing $b] {
	$canv(c) move all 0 [expr - $canv(YMatrixHide)]
	$canv(c) configure -height $canv(height)
    } else {
	$canv(c) move all 0 $canv(YMatrixHide)
	$canv(c) configure -height $canv(matrixHiddenHeight)
    }
}

/////////////////////////////////////////////////////////////////////////////

set hideCommandLine_ 0
proc hideCommandLine {{toggle 0}} {
    global hideCommandLine_

    if $toggle {set hideCommandLine_ [expr !$hideCommandLine_]}
    if $hideCommandLine_ {
	pack forget .cmd.cmdline
	pack forget .cmd.f.labelc
    } else {
        pack .cmd.cmdline -before .cmd.talk -fill x -side top -expand yes
	pack .cmd.f.labelc -before .cmd.f.labelt -side top -anchor e
    }
}

/////////////////////////////////////////////////////////////////////////////

set bidButtons_ [set bid_buttons_during_auction 1]
proc bidButtons {{toggle 0}} {
    global bidButtons_ bid_buttons_during_auction needAuctionUpdate

    // catch {talkmsg "bidButtons $toggle with bid_...=$bid_buttons_during_auction bidButtons_=$bidButtons_"}
    if $toggle {set bidButtons_ [expr !$bidButtons_]}
    if {$bidButtons_ == $bid_buttons_during_auction} return
    set bid_buttons_during_auction $bidButtons_
    set needAuctionUpdate 1
}

// Default on a small screen is no bidButtons.
if {$effectiveheight < 700} {bidButtons 1}

/////////////////////////////////////////////////////////////////////////////
// Deiconification
/////////////////////////////////////////////////////////////////////////////

set deiconifyIfBeeped_ 1
proc deiconifyIfBeeped {{toggle 0}} {
    global deiconifyIfBeeped_

    // catch {talkmsg "deiconifyIfBeeped $toggle with deiconifyIfBeeped_=$deiconifyIfBeeped_"}
    if $toggle {set deiconifyIfBeeped_ [expr !$deiconifyIfBeeped_]}
}

proc Floater_deiconify {} {
    global deiconifyIfBeeped_

    catch {
	if {$deiconifyIfBeeped_ && [wm state .] == "iconic"} {wm deiconify .}
    }
}

/////////////////////////////////////////////////////////////////////////////
// Auction Hide Time (< 0 means after first trick, N >= 0 means N seconds
// after final pass)
/////////////////////////////////////////////////////////////////////////////

if {$effectiveheight > 770} {
    set auction_hide_time -1
} else {
    set auction_hide_time 10
}

proc Floater_bell {} { catch { bell } }


