static char rcsid[] = "$Id: list.c,v 1.21 2010/07/16 22:19:24 twu Exp $";
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "list.h"
#include "listdef.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mem.h"

#define T List_T

T
List_push (T list, void *x) {
  T new = (T) MALLOC(sizeof(*new));
  
  new->first = x;
  new->rest = list;
  return new;
}

T
List_pop (T list, void **x) {
  T head;

  if (list) {
    head = list->rest;
    *x = list->first;
    FREE(list);
    return head;
  } else {
    return list;
  }
}

void *
List_head (T list) {
  return list->first;
}

T
List_next (T list) {
  if (list) {
    return list->rest;
  } else {
    return NULL;
  }
}

void
List_head_set (T this, void *x) {
  this->first = x;
  return;
}

void
List_free (T *list) {
  T prev;

  while ((prev = *list) != NULL) {
    *list = (*list)->rest;
    FREE(prev);
  }
}

T
List_reverse (T list) {
  T head = NULL, next;

  for ( ; list; list = next) {
    next = list->rest;
    list->rest = head;
    head = list;
  }
  return head;
}

int
List_length (T list) {
  int n;
  
  for (n = 0; list; list = list->rest) {
    n++;
  }
  return n;
}

T
List_truncate (T list, int n) {
  T head = list;

  while (--n > 0) {
    list = list->rest;
  }
  if (list) {
    list->rest = (T) NULL;
  }
  return head;
}

void **
List_to_array (T list, void *end) {
  void **array;
  int i, n = List_length(list);

  array = (void **) CALLOC((n+1),sizeof(*array));
  for (i = 0; i < n; i++) {
    array[i] = list->first;
    list = list->rest;
  }
  array[i] = end;
  return array;
}

void **
List_to_array_n (int *n, T list) {
  void **array;
  int i;

  *n = List_length(list);
  if (*n == 0) {
    return NULL;
  } else {
    array = (void **) CALLOC(*n,sizeof(*array));
    for (i = 0; i < *n; i++) {
      array[i] = list->first;
      list = list->rest;
    }
    return array;
  }
}

T
List_copy (T list) {
  T head, *p = &head;

  for ( ; list; list = list->rest) {
    *p = (T) MALLOC(sizeof(**p));
    (*p)->first = list->first;
    p = &(*p)->rest;
  }
  *p = NULL;
  return head;
}

void
List_dump (T list) {
  while (list) {
    printf("%p\n",list);
    list = list->rest;
  }
  return;
}

T
List_append (T list, T tail) {
  T *p = &list;

  while (*p) {
    p = &(*p)->rest;
  }
  *p = tail;
  return list;
}

void *
List_last_value (T this) {
  T last = NULL, r;

  for (r = this; r != NULL; r = r->rest) {
    last = r;
  }
  return last->first;
}

void *
List_index (T this, int index) {
  while (index-- > 0) {
    this = this->rest;
  }
  return this->first;
}


#if 0
/* Old definition, which doesn't make sense */
void
List_insert (T *listptr, void *x) {
  T new = (T) MALLOC(sizeof(*new));
  
  new->first = x;
  new->rest = *listptr;
  *listptr = new;

  return;
}
#else
T
List_insert (T p, void *x) {
  T new = (T) MALLOC(sizeof(*new));
  
  new->first = x;
  new->rest = p->rest;
  p->rest = new;
  return new;
}
#endif

void
List_reinsert (T *listptr, T cell) {
  cell->rest = *listptr;
  *listptr = cell;

  return;
}

T
List_transfer_one (T dest, T *source) {
  T next;

  next = (*source)->rest;
  (*source)->rest = dest;
  dest = *source;
  *source = next;
  return dest;
}

T
List_push_existing (T dest, T source) {
  T next;

  next = source->rest;
  source->rest = dest;
  return source;
}

T
List_from_string (char *string) {
  T this = NULL;
  char *p = string, *scout = string, *substring;
  int substringlen;

  while (*++scout != '\0') {
    if (*scout == ',') {
      substringlen = (scout-p)/sizeof(char);
      substring = (char *) CALLOC(substringlen+1,sizeof(char));
      strncpy(substring,p,substringlen);
      this = List_push(this,substring);
      scout++;
      p = scout;
    }
  }

  substringlen = (scout-p)/sizeof(char);
  substring = (char *) CALLOC(substringlen+1,sizeof(char));
  strncpy(substring,p,substringlen);
  this = List_push(this,substring);

  return List_reverse(this);
}
