Summary: A PostScript(TM) interpreter w/ Lexmark JetPrinter support
Name: ghostscript
%define version	5.10
Version: %{version}
Release: 990908lexmark
License: GPL
Group: Applications/Publishing
Source0: ftp://prep.ai.mit.edu:/pub/gnu/ghostscript-%{version}.tar.gz
Source1: ftp://prep.ai.mit.edu:/pub/gnu/ghostscript-%{version}jpeg.tar.gz
Source2: gdevlx7.c
Source3: dbman
Source4: changecartridge
Source5: README.lexmark
Patch0: gcc-head-mak.patch
Patch1: gs5.10-rth.patch
Patch2: gcc-head-7000.patch
Patch3: devs-mak-7000.patch
Patch4: gcc-head-5700.patch
Patch5: devs-mak-5700.patch
Patch6: gcc-head-2050-3200.patch
Patch7: devs-mak-2050-3200.patch
Requires: urw-fonts >= 1.1, ghostscript-fonts
BuildRoot: /var/tmp/ghostscript-root

%description
Ghostscript is a set of software that provides a PostScript(TM)
interpreter, a set of C procedures (the Ghostscript library, which
implements the graphics capabilities in the PostScript language) and an
interpreter for Portable Document Format (PDF) files.  Ghostscript
translates PostScript code into many common, bitmapped formats, like those
understood by your printer or screen.  Ghostscript is normally used to
display PostScript files and to print PostScript files to non-PostScript
printers.

If you need to display PostScript files or print them to non-PostScript
printers, you should install ghostscript.  If you install ghostscript, you
also need to install the ghostscript-fonts package.

This version of GhostScript contains Lexmark 7000 and 5700 JetPrinter driver.

%prep
%setup -q -n gs%{version}
%setup -q -T -D -a 1 -n gs%{version}
%patch0 -p0 
%patch1 -p1 -b .rth
%patch2
%patch3
%patch4
%patch5
%patch6
%patch7
./tar_cat
ln -s unix-gcc.mak Makefile
cp $RPM_SOURCE_DIR/gdevlx7.c .
cp $RPM_SOURCE_DIR/README.lexmark .


%build
make RPM_OPT_FLAGS="$RPM_OPT_FLAGS" prefix=/usr

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/usr/{bin,man,doc}
make install prefix=$RPM_BUILD_ROOT/usr
ln -sf gs.1 $RPM_BUILD_ROOT/usr/man/man1/ghostscript.1
ln -sf gs $RPM_BUILD_ROOT/usr/bin/ghostscript
strip $RPM_BUILD_ROOT/usr/bin/gs
cp -f $RPM_SOURCE_DIR/dbman $RPM_BUILD_ROOT/usr/bin/dbman
cp -f $RPM_SOURCE_DIR/changecartridge $RPM_BUILD_ROOT/usr/bin
cp README.lexmark $RPM_BUILD_ROOT/usr/doc/ghostscript-%{PACKAGE_VERSION}
%clean
rm -rf $RPM_BUILD_ROOT

%post
if [ -f /usr/lib/rhs/rhs-printfilters/printerdb ];then
/usr/bin/dbman -i
fi

%preun
if [ -f /usr/lib/rhs/rhs-printfilters/printerdb ];then
/usr/bin/dbman -e
fi
 
%files
%defattr(-,root,root)
/usr/doc/ghostscript-%{PACKAGE_VERSION}
/usr/bin/*
%dir /usr/share/ghostscript
%dir /usr/share/ghostscript/%{PACKAGE_VERSION}
/usr/share/ghostscript/%{PACKAGE_VERSION}/*ps
/usr/share/ghostscript/%{PACKAGE_VERSION}/*upp
%config /usr/share/ghostscript/%{version}/Fontmap
/usr/share/ghostscript/%{PACKAGE_VERSION}/examples
/usr/man/*/*


%changelog
* Wed Sep  8 1999 Henryk Paluch <paluch@bimbo.fjfi.cvut.cz>
  - number of packets was wrong in print_cols(), caused printing
    two noise stripes at the end of line
* Wed Aug 25 1999 Henryk Paluch <paluch@bimbo.fjfi.cvut.cz>
  - fixed missing README.lexmark in *.src.rpm
  - cleaned up print_cols() in gdevlx7.c driver
  - the driver now uses two types of compression - even complicated
    pictures should be printed in one pass

* Sat Aug 14 1999 Henryk Paluch <paluch@bimbo.fjfi.cvut.cz>
  - changes for upcoming Lexmark GS driver

* Mon Apr  5 1999 Bill Nottingham <notting@redhat.com>
- fix typo in config patch.

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 6)

* Mon Mar 15 1999 Cristian Gafton <gafton@redhat.com>
- added patch from rth to fix alignement problems on the alpha.

* Wed Feb 24 1999 Preston Brown <pbrown@redhat.com>
- Injected new description and group.

* Mon Feb 08 1999 Bill Nottingham <notting@redhat.com>
- add uniprint .upp files

* Sat Feb 06 1999 Preston Brown <pbrown@redhat.com>
- fontpath update.

* Wed Dec 23 1998 Preston Brown <pbrown@redhat.com>
- updates for ghostscript 5.10

* Fri Nov 13 1998 Preston Brown <pbrown@redhat.com>
- updated to use shared urw-fonts package.

* Mon Nov 09 1998 Preston Brown <pbrown@redhat.com>
- turned on truetype (ttf) font support.

* Thu Jul  2 1998 Jeff Johnson <jbj@redhat.com>
- updated to 4.03.

* Tue May 05 1998 Cristian Gafton <gafton@redhat.com>
- enabled more printer drivers
- buildroot

* Mon Apr 27 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr

* Mon Mar 03 1997 Erik Troan <ewt@redhat.com>
- Made /usr/share/ghostscript/3.33/Fontmap a config file.
