/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.Checksummer;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ChecksumInputStream
extends FilterInputStream {
    private InputStream subsumedStream;
    private Checksummer _cksummer;
    private long _nBytes;

    public ChecksumInputStream(InputStream inputStream, Checksummer checksummer) {
        super(inputStream);
        this.subsumedStream = inputStream;
        this._cksummer = checksummer;
        this._nBytes = 0L;
    }

    @Override
    public int read() throws IOException {
        int n = this.subsumedStream.read();
        if (n >= 0) {
            ++this._nBytes;
            if (this._cksummer != null) {
                this._cksummer.update(n);
            }
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = this.subsumedStream.read(byArray);
        if (n > 0) {
            if (this._cksummer != null) {
                this._cksummer.update(byArray);
            }
            this._nBytes += (long)n;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if ((n2 = this.subsumedStream.read(byArray, n, n2)) > 0) {
            if (this._cksummer != null) {
                this._cksummer.update(byArray, n, n2);
            }
            this._nBytes += (long)n2;
        }
        return n2;
    }

    @Override
    public long skip(long l) throws IOException {
        int n;
        byte[] byArray;
        int n2;
        long l2 = 0L;
        while (l > 0L && (n2 = this.read(byArray = new byte[n = (int)(l > 8192L ? 8192L : l)])) > 0) {
            l2 += (long)n2;
            l -= (long)n2;
        }
        return l2;
    }

    @Override
    public void close() throws IOException {
        this.subsumedStream.close();
    }

    public long getNBytes() {
        return this._nBytes;
    }

    public Checksummer getChecksummer() {
        return this._cksummer;
    }
}

