/****************************************************************************
**
** $Id: TextCodec.h,v 1.5 2004/01/11 20:11:13 riemer Exp $
**
** Copyright (C) 1999-2004 Tilo Riemer <riemer@lincvs.org>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** LinCVS is available under two different licenses:
**
** If LinCVS is linked against the GPLed version of Qt 
** LinCVS is released under the terms of GPL also.
**
** If LinCVS is linked against a nonGPLed version of Qt 
** LinCVS is released under the terms of the 
** LinCVS License for non-Unix platforms (LLNU)
**
**
** LinCVS License for non-Unix platforms (LLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than LinCVS.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** LinCVS License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation; either version 2 of the License, or 
** (at your  option) any later version.  This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#ifndef TEXTCODEC_H_20031008
#define TEXTCODEC_H_20031008

//----------------------------------------------------------------------------

#include <qdict.h>
#include <qptrvector.h>
#include <qtextcodec.h>

//----------------------------------------------------------------------------

namespace TextCodec {
   static const char DEFAULT_CODEC[]    = "ISO8859-1";
   static const char CODEC_FOR_LOCALE[] = "CODEC_FOR_LOCALE";

   struct SCodec {
      SCodec(QString n, QString c) : name(n), comment(c) {}
      QString name;
      QString comment;
   };
};

//----------------------------------------------------------------------------

//exceptions
class XI18n {};
class XCreateCodecFailed : public XI18n {};

//----------------------------------------------------------------------------

class CTextCodecPool
{
public:
   
   /**
      Creates the codec pool. After construction the pool is empty.
   */
   CTextCodecPool();
   
   ~CTextCodecPool() {;}

   /** 
       Creates and adds the default codec (ISO8859-1).
       If the codec exists already this function does nothing.
       If creation of codec fails the functions throws an 
       exception (XCreateCodecFailed).
   */
   void addDefaultCodec();

   /** 
       Creates and adds a codec for locale. 
       If the codec exists already this function does nothing.
       If creation of codec fails the functions throws an 
       exception (XCreateCodecFailed).
   */
   void addCodecForLocale();
   
   /** 
       Creates and adds a codec for passed name. 
       If the codec exists already this function does nothing.
       If creation of codec fails the functions throws an 
       exception (XCreateCodecFailed).
   */
   void addCodecForName(const char* name);

   /* 
      Returns a pointer at the default codec or 0 if the 
      codec does not exist. 
   */
   QTextCodec *pDefaultCodec();

   /* 
      Returns a pointer at the codec-for-locale or 0 if the 
      codec does not exist. 
   */
   QTextCodec *pCodecForLocale();

   /* 
      Returns a pointer at the codec-for-name or 0 if the 
      codec does not exist.
   */
   QTextCodec *pCodecForName(const char* name);

   /** Returns the name of codec for locale. */
   QString nameOfCodecForLocale() const { return m_nameOfCodecForLocale; }

   /** Returns a pointer at a vector containing the supported codecs. */
   const QPtrVector<TextCodec::SCodec>* supportedCodecs() const { return &m_supportedCodecs; }
   
private:

   void initSupportedCodecs();

   QDict<QTextCodec> m_codecDict;
   QString m_nameOfCodecForLocale;
   QPtrVector<TextCodec::SCodec> m_supportedCodecs;
};

//----------------------------------------------------------------------------

#endif //TEXTCODEC_H_20031008
