/****************************************************************************
 **
 ** $Id: tzconvert.h,v 1.1 2004/12/05 23:38:27 frank Exp $
 **
 ** Copyright (C) 1999-2004 Tilo Riemer <riemer@lincvs.org>,
 **                         Frank Hemer <frank@hemer.org>
 **
 **
 **----------------------------------------------------------------------------
 **
 **----------------------------------------------------------------------------
 **
 ** LinCVS is available under two different licenses:
 **
 ** If LinCVS is linked against the GPLed version of Qt 
 ** LinCVS is released under the terms of GPL also.
 **
 ** If LinCVS is linked against a nonGPLed version of Qt 
 ** LinCVS is released under the terms of the 
 ** LinCVS License for non-Unix platforms (LLNU)
 **
 **
 ** LinCVS License for non-Unix platforms (LLNU):
 **
 ** Redistribution and use in binary form, without modification, 
 ** are permitted provided that the following conditions are met:
 **
 ** 1. Redistributions in binary form must reproduce the above copyright
 **    notice, this list of conditions and the following disclaimer in the
 **    documentation and/or other materials provided with the distribution.
 ** 2. It is not permitted to distribute the binary package under a name
 **    different than LinCVS.
 ** 3. The name of the authors may not be used to endorse or promote
 **    products derived from this software without specific prior written
 **    permission.
 ** 4. The source code is the creative property of the authors.
 **    Extensions and development under the terms of the Gnu Public License
 **    are limited to the Unix platform. Any distribution or compilation of 
 **    the source code against libraries licensed other than gpl requires 
 **    the written permission of the authors.
 **
 **
 ** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
 ** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 ** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 ** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
 ** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 ** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
 ** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 ** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 ** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 ** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 ** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **
 **
 **
 ** LinCVS License for Unix platforms:
 **
 ** This program is free software; you can redistribute it and/or modify 
 ** it under the terms of the GNU General Public License as published by 
 ** the Free Software Foundation; either version 2 of the License, or 
 ** (at your  option) any later version.  This program is distributed in 
 ** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
 ** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 ** PARTICULAR PURPOSE.
 **
 ** See the GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software Foundation,
 ** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 **
 *****************************************************************************/

#ifndef TZCONVERT_H
#define TZCONVERT_H

#include "globals.h"

inline QDateTime convertTimeZone(QDateTime &dateTime, bool hasDSTBug, bool toUTC)
{
   //ATTENTION: we have to check the timezone for modification time
   //of every file because we have files modified in the winter
   //and files modified in the summer

   Q_UNUSED(hasDSTBug)

#ifdef USE_TM_GMTOFF
      int diff = 0;
   struct tm *result = NULL;
   time_t t_loc = TIMEZERO.secsTo(dateTime);
   result = localtime(&t_loc);
   if (result) {
      diff = -(result->tm_gmtoff);
   }
#else
   int diff = timeZoneDiffInSecs;
   struct tm *result = NULL;

   time_t t_loc = TIMEZERO.secsTo(dateTime);
   result = localtime(&t_loc);
   if (result) {
      if (result->tm_isdst > 0) diff -= 3600;  //daylight is active for THIS file
   }
#endif
   if (toUTC) {
      return dateTime.addSecs(diff);
   } else {
      return dateTime.addSecs(-diff);
   }
}

//----------------------------------------------------------------------------

inline QDateTime getAsUTC(QDateTime &dateTime, bool hasDSTBug) {
   return convertTimeZone(dateTime, hasDSTBug, TRUE);
}

//----------------------------------------------------------------------------

inline QDateTime getAsLocal(QDateTime &dateTime, bool hasDSTBug) {
   return convertTimeZone(dateTime, hasDSTBug, FALSE);
}

#endif
