/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  char *AFgetHrec (const char name[], const struct AF_info *Hinfo)

Purpose:
  Find a named record in an AFsp information structure

Description:
  This routine searches through records in an AFsp information structure,
  looking for a match to a record with a given name.  A pointer to the data
  value for that record is returned.

  For the purpose of this routine, the records are assumed to be terminated by
  nulls.  If the header does not follow this format, this routine will not find
  records to match and will silently return  a NULL pointer.

  AFsp Information Records:
    The header information records are separated by null characters.  The name
    field is the first part of the record and the value field is the remainder.
    Standard names are terminated by a ':' character, which effectively
    delimits the name field from the value field.

Parameters:
  <-  char *AFgetHrec
      Pointer to a null terminated value string in the information string
   -> const char name[]
      Record name to be matched.  An empty name will match the first record.
   -> const struct AF_info *Hinfo
      AFsp information structure

Author / revision:
  P. Kabal  Copyright (C) 1998
  $Revision: 1.20 $  $Date: 1998/06/17 15:32:32 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: AFgetHrec.c 1.20 1998/06/17 libtsp-v3r0 $";

#include <libtsp/AFheader.h>
#include <libtsp/AFpar.h>
#include <libtsp/Xstring.h>


char *
AFgetHrec (name, Hinfo)

     const char name[];
     const struct AF_info *Hinfo;

{
  const char *pst;
  const char *h_end;
  const char *r_term;
  int lenn;

  if (Hinfo == NULL || Hinfo->Info == NULL || Hinfo->N == 0)
    return NULL;

  h_end = &Hinfo->Info[Hinfo->N];
  pst = Hinfo->Info;
  lenn = strlen (name);
  while (pst < h_end) {

    /* Find the record terminator */
    r_term = (char *) memchr (pst, '\0', h_end - pst);
    if (r_term == NULL)
      break;

    /* Check for a name match */
    if (r_term - pst >= lenn && memcmp (pst, name, lenn) == 0 ) {
      return ((char *) (pst + lenn));
    }
    pst = r_term + 1;
  }

/* No match to the name */
  return NULL;
}
