/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  AFILE *AFsetNHwrite (FILE *fp, int Ftype, int Dformat, long int Nchan,
                       double Sfreq)

Purpose:
  Set file format information for a headerless audio file

Description:
  This routine opens and sets the file format information for a headerless
  audio file.

Parameters:
  <-  AFILE AFsetNHwrite
      Audio file pointer for the audio file.  In case of error, the audio file
      pointer is set to NULL.
   -> FILE *fp
      File pointer for the audio file
   -> int Ftype
      File type
        FTW_NH_EB    = 3, Headerless file (big-endian byte order)
        FW_NH_EL     = 4, Headerless file (little-endian byte order)
        FW_NH_NATIVE = 5, Headerless file (native byte order)
        FW_NH_SWAP   = 6, Headerless file (swapped byte order)
   -> int Dformat
      Data format
        FD_MULAW8  = 1,  mu-law 8-bit data
        FD_ALAW8   = 2,  A-law 8-bit data
        FD_UINT8   = 3,  offset-binary 8-bit integer data
        FD_INT8    = 4,  two's-complement 8-bit integer data
        FD_INT16   = 5,  two's-complement 16-bit integer data
        FD_FLOAT32 = 6,  32-bit float data
	FD_FLOAT64 = 7,  64-bit float data
        FD_TEXT    = 8,  text data
   -> long int Nchan
      Number of channels
   -> double Sfreq
      Sampling frequency

Author / revision:
  P. Kabal  Copyright (C) 1997
  $Revision: 1.22 $  $Date: 1997/10/09 15:58:27 $

-------------------------------------------------------------------------*/

static char rcsid [] = "$Id: AFsetNHwrite.c 1.22 1997/10/09 libtsp-v3r0 $";

#include <string.h>

#include <libtsp.h>
#include <libtsp/AFheader.h>
#include <libtsp/AFpar.h>
#include <libtsp/AFmsg.h>


AFILE *
AFsetNHwrite (fp, Ftype, Dformat, Nchan, Sfreq)

     FILE *fp;
     int Ftype;
     int Dformat;
     long int Nchan;
     double Sfreq;

{
  AFILE *AFp;
  int Swapb;

/* Set up the swap parameter */
  switch (Ftype) {
  case FTW_NH_EB:
    Swapb = DS_EB;
    break;
  case FTW_NH_EL:
    Swapb = DS_EL;
    break;
  case FTW_NH_NATIVE:
    Swapb = DS_NATIVE;
    break;
  case FTW_NH_SWAP:
    Swapb = DS_SWAP;
    break;
  default:
    UTwarn ("AFsetNHwrite - %s: \"%d\"", AFM_NH_BadFType, Ftype);
    return NULL;
  }

/* Set the parameters for file access */
  AFp = AFsetWrite (fp, FT_NH, Dformat, Swapb, Sfreq, 1.0, Nchan);

  return AFp;
}
