/*------------ Telecommunications & Signal Processing Lab -------------
                         McGill University

Routine:
  int FLterm (FILE *fp)

Purpose:
  Determine if a file pointer is associated with a terminal

Description:
  This routine determines if a file specified by its file pointer is associated
  with a terminal device.

Parameters:
  <-  int FLterm
      Return value, 1 for a terminal, 0 otherwise
   -> FILE *fp
      File pointer

Author / revision:
  P. Kabal  Copyright (C) 1997
  $Revision: 1.8 $  $Date: 1997/10/14 15:51:02 $

----------------------------------------------------------------------*/

static char rcsid[] = "$Id: FLterm.c 1.8 1997/10/14 libtsp-v3r0 $";

#include <libtsp/nucleus.h>
#include <libtsp/Xstdio.h>	/* fileno */
#include <libtsp/sysOS.h>	/* OS defines */


#ifdef MSDOS
#  ifndef unix
#    define USE__NAME
#  endif
#endif

#ifdef USE__NAME
#  include <io.h>
#  define FILENO	_fileno
#  define ISATTY	_isatty
#else
#  include <unistd.h>
#  define FILENO	fileno
#  define ISATTY	isatty
#endif


int
FLterm (fp)

     FILE *fp;

{
  return ISATTY (FILENO (fp));
}
