/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  void VRfLog10 (const float x[], float y[], int N)

Purpose:
  Find the logarithm (base 10) of each element of an array

Description:
  This routine finds the logarithm (base 10) for each element of an array.
    y[i] = log10(x[i]),  0 <= i < N.

Parameters:
   -> const float x[]
      Input array (N elements)
  <-  float y[]
      Output array (N elements).  The output array can be the same as the input
      array.
   -> int N
      Number of elements in the arrays (may be zero)

Author / revision:
  P. Kabal  Copyright (C) 1997
  $Revision: 1.6 $  $Date: 1997/10/11 02:10:40 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: VRfLog10.c 1.6 1997/10/11 libtsp-v3r0 $";

#include <math.h>

#include <libtsp.h>
#include <libtsp/VRmsg.h>


void
VRfLog10 (x, y, N)

     const float x[];
     float y[];
     int N;

{
  int i;

  for (i = 0; i < N; ++i) {
    if (x[i] >= 0)
      y[i] = log10 (x[i]);
    else
      UThalt ("VRfLog10: %s", VRM_NegVal);
  }

  return;
}
