#include <asm/types.h>
#include <string.h>
#include "../martian.h"
#include "common.h"
#include "log.h"
#include <stdio.h>

#include "core.h"
#include "overriden_core.h"



#define CIRC_CNT(head,tail,size) (((head) - (tail)) & ((size)-1))
#define CIRC_CNT_TO_END(head,tail,size) \
	({int end = (size) - (tail); \
	  int n = ((head) + end) & ((size)-1); \
	  n < end ? n : end;})


static __inline__ void atomic_dec(atomic_t *v)
{
	__asm__ __volatile__(
		LOCK "decl %0"
		:"=m" (v->counter)
		:"m" (v->counter));
}

extern struct _stats {
	int cring, cstream, cbit3;
	int dual_port_tx, dual_port_rx, io_dual_port_rx;
	int tx, rx, pdm_rx;
	int dcp;
} stats;

struct core_stats core;

unsigned char *rd7_isr;

#define DECLARE_FIFO(type, fifo) 	\
extern type *fifo##_rptr, *fifo##_wptr;	\
extern type *fifo##_sptr, *fifo##_eptr



static inline void copy_dcp_block(int c, struct mcirc *circ)
{
	int cnt_room = sizeof DCPBuffer - DCPwIndex;
	if (cnt_room <= c) {
		memcpy(&DCPBufferStart[DCPwIndex], &Mcb->dcp_buf[circ->tail], cnt_room);
		memcpy(DCPBufferStart, &Mcb->dcp_buf[circ->tail + cnt_room], c - cnt_room);
		DCPwIndex = c - cnt_room;
	}
	else {
		memcpy(&DCPBufferStart[DCPwIndex], &Mcb->dcp_buf[circ->tail], c);
		DCPwIndex += c;
	}
	circ->tail = (circ->tail + c) & (sizeof Mcb->dcp_buf - 1);
}

static inline void process_dcp(void)
{
	struct mcirc *circ = &Mcb->dcp_circ;
	int c = CIRC_CNT_TO_END(circ->head, circ->tail, sizeof Mcb->dcp_buf);
	copy_dcp_block(c, circ);

	c = CIRC_CNT(circ->head, circ->tail, sizeof Mcb->dcp_buf);
	copy_dcp_block(c, circ);
}

static inline void post_process_ring (void )
{
	char dig_str[] = "<r0>";
	dig_str[2] = '0' + dp_ring_int_count;
	logdebugadd (Event, dig_str);

	if (dp_ring_int_count <= 1) 
	{
		x_wakeup();
		io_timer = x_current_time();
	}
	else {
		dp_polarity_int = 0;
		dp_ring_int_count = 0;
		dp_ring_int = 1;
		dp_init_local_phone_timer();	/* stub */
		LOGDEBUG(Event, "ring\n");
	}
}

int isr_defered(void )
{
	__u8 rd7 = *rd7_isr;

	if (rd7 & 0x2)
		post_process_ring();

	if (rd7 & 0x4)
		process_dcp();

	atomic_dec (&Mcb->UnservedIrqs);

	return 1;

}

/* hooked */

#ifndef UART_MSR_DCD
#define UART_MSR_DCD	0x80
#endif 

#ifndef UART_MSR_DDCD
#define UART_MSR_DDCD	0x01
#endif 

void UART_cd_on() 
{
	extern void do_UART_cd_on (void ); 
	do_UART_cd_on();
}

int core_carrier_lost;
void UART_cd_off() 
{
	extern void do_UART_cd_off (void ); 
	if (io_uart_msr & UART_MSR_DCD) 
		core_carrier_lost = 1;

	do_UART_cd_off();
}

void io_init_dce_rx_fifo () {
	DECLARE_FIFO (__u16, io_dce_rx);
	extern __u16 io_dce_rx_buff[];
	extern struct martian_common *Mcb;

	io_dce_rx_sptr =
	io_dce_rx_rptr =
	io_dce_rx_wptr = io_dce_rx_buff;
	/*io_dce_rx_wptr = Mcb->io_dce_rx_buff;*/ /* in case that dce_rx should be always in common */

	/*io_dce_rx_eptr = Mcb->io_dce_rx_buff +*/
	io_dce_rx_eptr = io_dce_rx_buff +
		(sizeof Mcb->io_dce_rx_buff / sizeof Mcb->io_dce_rx_buff[0]);
}

