/************************************************************************/
/* Module : contexthelp.c					        */
/* Purpose: provides context sensitive help                         	*/
/* Mod. By: Keith R. Davis				                */
/* Date   : 12/8/95					                */
/* Notes  : Copyright(c) 1996-98 Mutiny Bay Software	                */
/*          Copyright(c) 1995 ipvr stuttgart and thomas harrer          */
/*          modified source to add a number of customizations for use   */
/*          with mpsql.                                                 */
/************************************************************************/

#include <Xm/Xm.h>
#include "contexthelp.h"
#include "helpp.h"

/* from libhelp  */
#include "help.h"

/* -------------------------------------------------------------------- *
*  module identification
** -------------------------------------------------------------------- */
#ifdef RCSID
static char rcsid [] =
    "$Id: contexthelp.c,v 1.8 1995/06/28 12:59:30 thomas Exp $";
#endif /* RCSID */

/* -------------------------------------------------------------------- *
*  private prototypes
** -------------------------------------------------------------------- */
static char*  context_get_help_file (int);

/* -------------------------------------------------------------------- *
*   procedure-name:	libhelp_context_cb
**
**  purpose:		provides context sensitive help
** -------------------------------------------------------------------- *
**  args:		standard callback args.
**			call_data is actually an integer. 
**			symbols for those are defined in context.h
**  precondition:	callback must be added via XtAddCallback
**  postcondition:	context sensitive help is initiated.
**  error handling.:	-
** -------------------------------------------------------------------- */
void
libhelp_context_cb (/* i  */ Widget 	w,
		    /* i  */ XtPointer 	client_data,
		    /* i  */ XtPointer 	call_data)
{
    /* local data  */
    int 		command = (int) client_data;
    char*		help_file;

    /* get the help file from the help symbol.  */
    help_file = context_get_help_file (command);

    if (help_file != NULL) {
	/*
	 *  we just call libhelp. if there is already a help browser, 
	 *  libhelp uses it. else it creates a new one.
	 */
	(void) get_help (NULL, help_file, NULL);
    }
}

/* -------------------------------------------------------------------- *
*   procedure-name:	context_get_help_file
**
**  purpose:		return the help file
** -------------------------------------------------------------------- */
static char*
context_get_help_file (/* i  */ int request)
{
    int i = 0;
    
    /* the mapping between context symbols and filenames.  */
    typedef struct context_file_s {
	int	help_symbol;
	char*	filename;
    } context_file_t;

    /* this is the list of errors.  */
    static context_file_t help_list [] =  {
	context_mapping
    };

    while (help_list[i].help_symbol != cx_end) {

	if (help_list[i].help_symbol == request) {
	    return help_list[i].filename;
	}
	i++;

	/* i feel the need for an additional termination condition.  */
	if (i > cx_max) {
	    break;
	}
    }
    return NULL;
}
