/************************************************************************/
/* File   : llist.h				                        */
/* Purpose: linked list  module header		                        */
/* By     : Keith R. Davis				                */
/* Date   : 12/27/95				                        */
/* Notes  : Copyright(c) 1996-98 Mutiny Bay Software                 	*/
/************************************************************************/

#ifndef _LLIST_H
#define _LLIST_H

/* linked list stuff for sql file buffers */

typedef struct _llist_buffer{
  textBuffer            *buffer;        /* text buffer                          */
  int                   modified;       /* buffer modified flag                 */
  int                   ins_pos;        /* last insert position                 */
  char                  *filename;      /* buffer's file name                   */             
  struct _llist_buffer  *next;          /* ptr to next buffer                   */
  struct _llist_buffer  *prev;          /* ptr to previous buffer               */
}LLISTbuffer;

extern LLISTbuffer      *buffer_head;   /* buffer list head                     */
extern LLISTbuffer      *buffer_tail;   /* buffer list tail                     */
extern LLISTbuffer      *buffer_curr;   /* current pos in buffer list           */

extern LLISTbuffer empty_buffer;        /* dummy data node                      */

/* initializes linked list */
LLISTbuffer* LLIST_Init(void);

/* deletes node from linked list */
void LLIST_Delete(LLISTbuffer *node);

/* inserts node into linked list before specified node*/
LLISTbuffer* LLIST_Insert(int mod, char *file, LLISTbuffer *node);

/* disposes of linked list */
void LLIST_Remove(void);

/* returns count of items in the linked list */
int LLIST_Count(void);

/* returns node at specified index */
LLISTbuffer* LLIST_Get(int index);
	
#endif	
