/************************************************************************/
/* File   : util.h    				                        */
/* Purpose: utility module header		                        */
/* By     : Keith R. Davis				                */
/* Date   : 12/27/95				                        */
/* Notes  : Copyright(c) 1996-98 Mutiny Bay Software			*/
/*          Copyright(c) 1994, Regents of the University of California  */
/************************************************************************/

#ifndef _UTIL_H
#define _UTIL_H

/* MODIFIES the string passed in and returns ptr to it */
extern char* leftTrim(char* s);  
extern char* rightTrim(char* s);
extern char* doubleTrim(char* s);

/* dupstr : copies a string, while making room for it */
/* the CALLER is responsible for freeing the space */
/* returns NULL if the argument is NULL */
extern char* dupstr(char *s);

/* reverses a character string */
void reverse(char *s);

/* converts int value to character */
char* itoa(int n, char *s);

/* removes white space from a string */
void removeWhiteSpace(char *string);
  
#endif
