/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

class FastStringBuffer {
    String string;
    char[] buffer;
    int length;
    boolean doublesCapacity;

    public FastStringBuffer() {
        this("");
    }

    public FastStringBuffer(String string) {
        if (string == null || string.equals("")) {
            this.buffer = new char[8];
        } else {
            this.buffer = new char[string.length() + 1];
            this.setStringValue(string);
        }
        this.doublesCapacity = false;
    }

    public FastStringBuffer(String string, int n, int n2) {
        this.buffer = new char[n2 - n];
        this.length = n2 - n;
        this.string = null;
        this.doublesCapacity = false;
        string.getChars(n, n2, this.buffer, 0);
    }

    public FastStringBuffer(char c) {
        this.buffer = new char[8];
        this.buffer[0] = c;
        this.length = 1;
        this.doublesCapacity = false;
    }

    void _increaseCapacityTo(int n) {
        if (this.buffer.length <= n) {
            char[] cArray = this.buffer;
            this.buffer = this.doublesCapacity ? new char[n * 2] : new char[n + 20];
            System.arraycopy(cArray, 0, this.buffer, 0, cArray.length);
        }
    }

    public void setDoublesCapacityWhenGrowing(boolean bl) {
        this.doublesCapacity = bl;
    }

    public boolean doublesCapacityWhenGrowing() {
        return this.doublesCapacity;
    }

    public void setStringValue(String string) {
        if (string == null || string.equals("")) {
            this.length = 0;
        } else {
            this.length = string.length();
            this._increaseCapacityTo(this.length);
            string.getChars(0, this.length, this.buffer, 0);
        }
        this.string = string;
    }

    public String toString() {
        if (this.string == null) {
            this.string = new String(this.buffer, 0, this.length);
        }
        return this.string;
    }

    public char charAt(int n) {
        if (n < 0 || n >= this.length) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.buffer[n];
    }

    public int indexOf(char c, int n) {
        if (n < 0 || n >= this.length) {
            throw new StringIndexOutOfBoundsException(n);
        }
        int n2 = n;
        while (n2 < this.length) {
            if (this.buffer[n2] == c) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int indexOf(char c) {
        return this.indexOf(c, 0);
    }

    public boolean tabOrSpaceAt(int n) {
        if (n < 0 || n >= this.length) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.buffer[n] == ' ' || this.buffer[n] == '\t';
    }

    public void append(char c) {
        this._increaseCapacityTo(this.length + 1);
        this.buffer[this.length++] = c;
        this.string = null;
    }

    public void append(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        this._increaseCapacityTo(this.length + string.length());
        string.getChars(0, string.length(), this.buffer, this.length);
        this.length += string.length();
        this.string = null;
    }

    public void insert(char c, int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n >= this.length) {
            this.append(c);
            return;
        }
        if (this.length < this.buffer.length) {
            if (n != this.length) {
                System.arraycopy(this.buffer, n, this.buffer, n + 1, this.length - n);
            }
            this.buffer[n] = c;
            ++this.length;
            this.string = null;
            return;
        }
        char[] cArray = this.buffer;
        this.buffer = new char[this.buffer.length + 20];
        if (n > 0) {
            System.arraycopy(cArray, 0, this.buffer, 0, n);
        }
        if (n != this.length) {
            System.arraycopy(cArray, n, this.buffer, n + 1, this.length - n);
        }
        this.buffer[n] = c;
        ++this.length;
        this.string = null;
    }

    public void insert(String string, int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n > this.length) {
            this.append(string);
            return;
        }
        if (string == null || string.equals("")) {
            return;
        }
        int n2 = string.length();
        if (this.length + n2 < this.buffer.length) {
            System.arraycopy(this.buffer, n, this.buffer, n + n2, this.length - n);
            string.getChars(0, n2, this.buffer, n);
            this.length += n2;
            this.string = null;
            return;
        }
        char[] cArray = this.buffer;
        this.buffer = new char[this.length + n2 + 20];
        if (n > 0) {
            System.arraycopy(cArray, 0, this.buffer, 0, n);
        }
        System.arraycopy(cArray, n, this.buffer, n + n2, this.length - n);
        string.getChars(0, n2, this.buffer, n);
        this.length += n2;
        this.string = null;
    }

    public void removeCharAt(int n) {
        if (n < 0 || n >= this.length) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n + 1 == this.length) {
            --this.length;
            this.string = null;
            return;
        }
        System.arraycopy(this.buffer, n + 1, this.buffer, n, this.length - (n + 1));
        --this.length;
        this.string = null;
    }

    public void truncateToLength(int n) {
        if (n < 0 || n > this.length) {
            return;
        }
        this.length = n;
        this.string = null;
    }

    public int length() {
        return this.length;
    }

    public void moveChars(int n, int n2) {
        if (n <= n2) {
            return;
        }
        if (n < 0 || n >= this.length) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0 || n2 >= this.length) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        System.arraycopy(this.buffer, n, this.buffer, n2, this.length - n);
        this.length -= n - n2;
        this.string = null;
    }

    public char[] charArray() {
        return this.buffer;
    }
}

