/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.io.Serializable;

public class Color
implements Serializable {
    public static final Color white = new Color(255, 255, 255);
    public static final Color lightGray = new Color(192, 192, 192);
    public static final Color gray = new Color(128, 128, 128);
    public static final Color darkGray = new Color(64, 64, 64);
    public static final Color black = new Color(0, 0, 0);
    public static final Color red = new Color(255, 0, 0);
    public static final Color pink = new Color(255, 175, 175);
    public static final Color orange = new Color(255, 200, 0);
    public static final Color yellow = new Color(255, 255, 0);
    public static final Color green = new Color(0, 255, 0);
    public static final Color magenta = new Color(255, 0, 255);
    public static final Color cyan = new Color(0, 255, 255);
    public static final Color blue = new Color(0, 0, 255);
    private transient int pData;
    int value;
    private static final long serialVersionUID = 118526816881161077L;
    private static final double FACTOR = 0.7000000000000001;

    private static void testColorValueRange(int n, int n2, int n3) {
        boolean bl = false;
        String string = "";
        if (n < 0 || n > 255) {
            bl = true;
            string = String.valueOf(string) + " Red";
        }
        if (n2 < 0 || n2 > 255) {
            bl = true;
            string = String.valueOf(string) + " Green";
        }
        if (n3 < 0 || n3 > 255) {
            bl = true;
            string = String.valueOf(string) + " Blue";
        }
        if (bl) {
            throw new IllegalArgumentException("Color parameter outside of expected range:" + string);
        }
    }

    private static void testColorValueRange(float f, float f2, float f3) {
        boolean bl = false;
        String string = "";
        if ((double)f < 0.0 || (double)f > 1.0) {
            bl = true;
            string = String.valueOf(string) + " Red";
        }
        if ((double)f2 < 0.0 || (double)f2 > 1.0) {
            bl = true;
            string = String.valueOf(string) + " Green";
        }
        if ((double)f3 < 0.0 || (double)f3 > 1.0) {
            bl = true;
            string = String.valueOf(string) + " Blue";
        }
        if (bl) {
            throw new IllegalArgumentException("Color parameter outside of expected range:" + string);
        }
    }

    public Color(int n, int n2, int n3) {
        this((n & 0xFF) << 16 | (n2 & 0xFF) << 8 | n3 & 0xFF);
    }

    public Color(int n) {
        this.value = 0xFF000000 | n;
    }

    public Color(float f, float f2, float f3) {
        this((int)(f * 255.0f), (int)(f2 * 255.0f), (int)(f3 * 255.0f));
    }

    public int getRed() {
        return this.getRGB() >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.getRGB() >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.getRGB() & 0xFF;
    }

    public int getRGB() {
        return this.value;
    }

    public Color brighter() {
        return new Color(Math.min((int)((double)this.getRed() * 1.4285714285714284), 255), Math.min((int)((double)this.getGreen() * 1.4285714285714284), 255), Math.min((int)((double)this.getBlue() * 1.4285714285714284), 255));
    }

    public Color darker() {
        return new Color(Math.max((int)((double)this.getRed() * 0.7000000000000001), 0), Math.max((int)((double)this.getGreen() * 0.7000000000000001), 0), Math.max((int)((double)this.getBlue() * 0.7000000000000001), 0));
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object instanceof Color && ((Color)object).value == this.value;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[r=" + this.getRed() + ",g=" + this.getGreen() + ",b=" + this.getBlue() + "]";
    }

    public static Color decode(String string) throws NumberFormatException {
        Integer n = Integer.decode(string);
        int n2 = n;
        return new Color(n2 >> 16 & 0xFF, n2 >> 8 & 0xFF, n2 & 0xFF);
    }

    public static Color getColor(String string) {
        return Color.getColor(string, null);
    }

    public static Color getColor(String string, Color color) {
        Integer n = Integer.getInteger(string);
        if (n == null) {
            return color;
        }
        int n2 = n;
        return new Color(n2 >> 16 & 0xFF, n2 >> 8 & 0xFF, n2 & 0xFF);
    }

    public static Color getColor(String string, int n) {
        Integer n2 = Integer.getInteger(string);
        int n3 = n2 != null ? n2 : n;
        return new Color(n3 >> 16 & 0xFF, n3 >> 8 & 0xFF, n3 & 0xFF);
    }

    public static int HSBtoRGB(float f, float f2, float f3) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (f2 == 0.0f) {
            n2 = n3 = (int)(f3 * 255.0f);
            n = n3;
        } else {
            double d = ((double)f - Math.floor(f)) * 6.0;
            double d2 = d - Math.floor(d);
            double d3 = (double)f3 * (1.0 - (double)f2);
            double d4 = (double)f3 * (1.0 - (double)f2 * d2);
            double d5 = (double)f3 * (1.0 - (double)f2 * (1.0 - d2));
            switch ((int)d) {
                case 0: {
                    n = (int)(f3 * 255.0f);
                    n2 = (int)(d5 * 255.0);
                    n3 = (int)(d3 * 255.0);
                    break;
                }
                case 1: {
                    n = (int)(d4 * 255.0);
                    n2 = (int)(f3 * 255.0f);
                    n3 = (int)(d3 * 255.0);
                    break;
                }
                case 2: {
                    n = (int)(d3 * 255.0);
                    n2 = (int)(f3 * 255.0f);
                    n3 = (int)(d5 * 255.0);
                    break;
                }
                case 3: {
                    n = (int)(d3 * 255.0);
                    n2 = (int)(d4 * 255.0);
                    n3 = (int)(f3 * 255.0f);
                    break;
                }
                case 4: {
                    n = (int)(d5 * 255.0);
                    n2 = (int)(d3 * 255.0);
                    n3 = (int)(f3 * 255.0f);
                    break;
                }
                case 5: {
                    n = (int)(f3 * 255.0f);
                    n2 = (int)(d3 * 255.0);
                    n3 = (int)(d4 * 255.0);
                    break;
                }
            }
        }
        return 0xFF000000 | n << 16 | n2 << 8 | n3;
    }

    public static float[] RGBtoHSB(int n, int n2, int n3, float[] fArray) {
        float f;
        int n4;
        int n5;
        if (fArray == null) {
            fArray = new float[3];
        }
        int n6 = n5 = n > n2 ? n : n2;
        if (n3 > n5) {
            n5 = n3;
        }
        int n7 = n4 = n < n2 ? n : n2;
        if (n3 < n4) {
            n4 = n3;
        }
        float f2 = (float)n5 / 255.0f;
        float f3 = n5 != 0 ? (float)(n5 - n4) / (float)n5 : 0.0f;
        if (f3 == 0.0f) {
            f = 0.0f;
        } else {
            float f4 = (float)(n5 - n) / (float)(n5 - n4);
            float f5 = (float)(n5 - n2) / (float)(n5 - n4);
            float f6 = (float)(n5 - n3) / (float)(n5 - n4);
            f = n == n5 ? f6 - f5 : (n2 == n5 ? 2.0f + f4 - f6 : 4.0f + f5 - f4);
            if ((f /= 6.0f) < 0.0f) {
                f += 1.0f;
            }
        }
        fArray[0] = f;
        fArray[1] = f3;
        fArray[2] = f2;
        return fArray;
    }

    public static Color getHSBColor(float f, float f2, float f3) {
        return new Color(Color.HSBtoRGB(f, f2, f3));
    }
}

