/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;
import java.util.Random;

public class BigInteger
extends Number {
    private int signum;
    private byte[] magnitude;
    private int bitCount = -1;
    private int bitLength = -1;
    private int firstNonzeroByteNum = -2;
    private int lowestSetBit = -2;
    private static final BigInteger ZERO = new BigInteger(new byte[0], 0);
    private static final int MAX_CONSTANT = 16;
    private static BigInteger[] posConst = new BigInteger[17];
    private static BigInteger[] negConst = new BigInteger[17];
    private static final byte[] bitLen;
    private static final byte[] bitCnt;
    private static final byte[] trailingZeroCnt;
    private static String[] zeros;
    private static final BigInteger ONE;
    private static final BigInteger TWO;
    private static final char ZERO_CHAR;
    private static int[] digitsPerLong;
    private static BigInteger[] longRadix;

    public BigInteger(byte[] byArray) throws NumberFormatException {
        if (byArray.length == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        if (byArray[0] < 0) {
            this.magnitude = BigInteger.makePositive(byArray);
            this.signum = -1;
            return;
        }
        this.magnitude = BigInteger.stripLeadingZeroBytes(byArray);
        this.signum = this.magnitude.length == 0 ? 0 : 1;
    }

    public BigInteger(int n, byte[] byArray) throws NumberFormatException {
        this.magnitude = BigInteger.stripLeadingZeroBytes(byArray);
        if (n < -1 || n > 1) {
            throw new NumberFormatException("Invalid signum value");
        }
        if (this.magnitude.length == 0) {
            this.signum = 0;
            return;
        }
        if (n == 0) {
            throw new NumberFormatException("signum-magnitude mismatch");
        }
        this.signum = n;
    }

    public BigInteger(String string, int n) throws NumberFormatException {
        int n2 = 0;
        if (n < 2 || n > 36) {
            throw new NumberFormatException("Radix out of range");
        }
        if (string.length() == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        this.signum = 1;
        if (string.charAt(0) == '-') {
            if (string.length() == 1) {
                throw new NumberFormatException("Zero length BigInteger");
            }
            this.signum = -1;
            n2 = 1;
        }
        while (n2 < string.length() && string.charAt(n2) == ZERO_CHAR) {
            ++n2;
        }
        if (n2 == string.length()) {
            this.signum = 0;
            this.magnitude = new byte[0];
            return;
        }
        int n3 = string.length() - n2;
        int n4 = n3 % digitsPerLong[n];
        if (n4 == 0) {
            n4 = digitsPerLong[n];
        }
        String string2 = string.substring(n2, n2 += n4);
        BigInteger bigInteger = BigInteger.valueOf(Long.parseLong(string2, n));
        while (n2 < string.length()) {
            long l;
            if ((l = Long.parseLong(string2 = string.substring(n2, n2 += digitsPerLong[n]), n)) < 0L) {
                throw new NumberFormatException("Illegal digit");
            }
            bigInteger = bigInteger.multiply(longRadix[n]).add(BigInteger.valueOf(l));
        }
        this.magnitude = bigInteger.magnitude;
    }

    public BigInteger(String string) throws NumberFormatException {
        this(string, 10);
    }

    public BigInteger(int n, Random random) throws IllegalArgumentException {
        this(1, BigInteger.randomBits(n, random));
    }

    private static byte[] randomBits(int n, Random random) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("numBits must be non-negative");
        }
        int n2 = (n + 7) / 8;
        byte[] byArray = new byte[n2];
        if (n2 > 0) {
            random.nextBytes(byArray);
            int n3 = 8 * n2 - n;
            byArray[0] = (byte)(byArray[0] & (1 << 8 - n3) - 1);
        }
        return byArray;
    }

    public BigInteger(int n, int n2, Random random) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        if (n < 2) {
            throw new ArithmeticException("bitLength < 2");
        }
        do {
            bigInteger2 = new BigInteger(n - 1, random).setBit(n - 1);
            if (n <= 16) {
                if (n > 2) {
                    bigInteger = bigInteger2.setBit(0);
                    continue;
                }
                bigInteger = bigInteger2;
                continue;
            }
            bigInteger = new BigInteger(BigInteger.plumbGeneratePrime(bigInteger2.magnitude), 1);
        } while ((bigInteger2 = bigInteger).bitLength() != n || !bigInteger2.isProbablePrime(n2));
        this.signum = 1;
        this.magnitude = bigInteger2.magnitude;
    }

    private BigInteger(byte[] byArray, int n) {
        this.signum = byArray.length == 0 ? 0 : n;
        this.magnitude = byArray;
    }

    public static BigInteger valueOf(long l) {
        if (l == 0L) {
            return ZERO;
        }
        if (l > 0L && l <= 16L) {
            return posConst[(int)l];
        }
        if (l < 0L && l >= -16L) {
            return negConst[(int)(-l)];
        }
        byte[] byArray = new byte[8];
        int n = 0;
        while (n < 8) {
            byArray[7 - n] = (byte)l;
            ++n;
            l >>= 8;
        }
        return new BigInteger(byArray);
    }

    private static BigInteger valueOf(byte[] byArray) {
        if (byArray[0] > 0) {
            return new BigInteger(byArray, 1);
        }
        return new BigInteger(byArray);
    }

    public BigInteger add(BigInteger bigInteger) throws ArithmeticException {
        if (bigInteger.signum == 0) {
            return this;
        }
        if (this.signum == 0) {
            return bigInteger;
        }
        if (bigInteger.signum == this.signum) {
            return new BigInteger(BigInteger.plumbAdd(this.magnitude, bigInteger.magnitude), this.signum);
        }
        if (this.signum < 0) {
            return BigInteger.plumbSubtract(bigInteger.magnitude, this.magnitude);
        }
        return BigInteger.plumbSubtract(this.magnitude, bigInteger.magnitude);
    }

    public BigInteger subtract(BigInteger bigInteger) {
        return this.add(new BigInteger(bigInteger.magnitude, -bigInteger.signum));
    }

    public BigInteger multiply(BigInteger bigInteger) {
        if (bigInteger.signum == 0 || this.signum == 0) {
            return ZERO;
        }
        return new BigInteger(BigInteger.plumbMultiply(this.magnitude, bigInteger.magnitude), this.signum * bigInteger.signum);
    }

    public BigInteger divide(BigInteger bigInteger) throws ArithmeticException {
        if (bigInteger.signum == 0) {
            throw new ArithmeticException("BigInteger divide by zero");
        }
        if (this.signum == 0) {
            return ZERO;
        }
        return new BigInteger(BigInteger.plumbDivide(this.magnitude, bigInteger.magnitude), this.signum * bigInteger.signum);
    }

    public BigInteger remainder(BigInteger bigInteger) throws ArithmeticException {
        if (bigInteger.signum == 0) {
            throw new ArithmeticException("BigInteger divide by zero");
        }
        if (this.signum == 0) {
            return ZERO;
        }
        if (this.magnitude.length < bigInteger.magnitude.length) {
            return this;
        }
        return new BigInteger(BigInteger.plumbRemainder(this.magnitude, bigInteger.magnitude), this.signum);
    }

    public BigInteger[] divideAndRemainder(BigInteger bigInteger) throws ArithmeticException {
        BigInteger[] bigIntegerArray = new BigInteger[2];
        if (bigInteger.signum == 0) {
            throw new ArithmeticException("BigInteger divide by zero");
        }
        if (this.signum == 0) {
            bigIntegerArray[0] = bigIntegerArray[1] = ZERO;
        } else if (this.magnitude.length < bigInteger.magnitude.length) {
            bigIntegerArray[0] = ZERO;
            bigIntegerArray[1] = this;
        } else {
            byte[][] byArray = BigInteger.plumbDivideAndRemainder(this.magnitude, bigInteger.magnitude);
            bigIntegerArray[0] = new BigInteger(byArray[0], this.signum * bigInteger.signum);
            bigIntegerArray[1] = new BigInteger(byArray[1], this.signum);
        }
        return bigIntegerArray;
    }

    public BigInteger pow(int n) throws ArithmeticException {
        if (n < 0) {
            throw new ArithmeticException("Negative exponent");
        }
        if (this.signum == 0) {
            if (n == 0) {
                return ONE;
            }
            return this;
        }
        BigInteger bigInteger = BigInteger.valueOf(n < 0 && (n & 1) == 1 ? -1 : 1);
        BigInteger bigInteger2 = this;
        while (n != 0) {
            if ((n & 1) == 1) {
                bigInteger = bigInteger.multiply(bigInteger2);
            }
            if ((n >>= 1) == 0) continue;
            bigInteger2 = new BigInteger(BigInteger.plumbSquare(bigInteger2.magnitude), 1);
        }
        return bigInteger;
    }

    public BigInteger gcd(BigInteger bigInteger) {
        if (bigInteger.signum == 0) {
            return this.abs();
        }
        if (this.signum == 0) {
            return bigInteger.abs();
        }
        return new BigInteger(BigInteger.plumbGcd(this.magnitude, bigInteger.magnitude), 1);
    }

    public BigInteger abs() {
        if (this.signum >= 0) {
            return this;
        }
        return this.negate();
    }

    public BigInteger negate() {
        return new BigInteger(this.magnitude, -this.signum);
    }

    public int signum() {
        return this.signum;
    }

    public BigInteger mod(BigInteger bigInteger) {
        if (bigInteger.signum <= 0) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        BigInteger bigInteger2 = this.remainder(bigInteger);
        if (bigInteger2.signum >= 0) {
            return bigInteger2;
        }
        return bigInteger2.add(bigInteger);
    }

    public BigInteger modPow(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        if (bigInteger2.signum <= 0) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        if (bigInteger.signum == 0) {
            return ONE;
        }
        boolean bl = bigInteger.signum < 0;
        if (bl) {
            bigInteger = bigInteger.negate();
        }
        BigInteger bigInteger5 = bigInteger4 = this.signum < 0 || this.compareTo(bigInteger2) >= 0 ? this.mod(bigInteger2) : this;
        if (bigInteger2.testBit(0)) {
            bigInteger3 = new BigInteger(BigInteger.plumbModPow(bigInteger4.magnitude, bigInteger.magnitude, bigInteger2.magnitude), 1);
        } else {
            int n = bigInteger2.getLowestSetBit();
            BigInteger bigInteger6 = bigInteger2.shiftRight(n);
            BigInteger bigInteger7 = ONE.shiftLeft(n);
            BigInteger bigInteger8 = new BigInteger(BigInteger.plumbModPow(bigInteger4.magnitude, bigInteger.magnitude, bigInteger6.magnitude), 1);
            BigInteger bigInteger9 = bigInteger4.modPow2(bigInteger, n);
            BigInteger bigInteger10 = bigInteger7.modInverse(bigInteger6);
            BigInteger bigInteger11 = bigInteger6.modInverse(bigInteger7);
            bigInteger3 = bigInteger8.multiply(bigInteger7).multiply(bigInteger10).add(bigInteger9.multiply(bigInteger6).multiply(bigInteger11)).mod(bigInteger2);
        }
        if (bl) {
            return bigInteger3.modInverse(bigInteger2);
        }
        return bigInteger3;
    }

    private BigInteger modPow2(BigInteger bigInteger, int n) {
        BigInteger bigInteger2 = BigInteger.valueOf(1L);
        BigInteger bigInteger3 = this.mod2(n);
        while (bigInteger.signum != 0) {
            if (bigInteger.testBit(0)) {
                bigInteger2 = bigInteger2.multiply(bigInteger3).mod2(n);
            }
            bigInteger = bigInteger.shiftRight(1);
            if (bigInteger.signum == 0) continue;
            bigInteger3 = new BigInteger(BigInteger.plumbSquare(bigInteger3.magnitude), 1).mod2(n);
        }
        return bigInteger2;
    }

    private BigInteger mod2(int n) {
        if (this.bitLength() <= n) {
            return this;
        }
        int n2 = (n + 7) / 8;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3] = this.magnitude[n3 + (this.magnitude.length - n2)];
            ++n3;
        }
        int n4 = 8 * n2 - n;
        byArray[0] = (byte)(byArray[0] & (1 << 8 - n4) - 1);
        if (byArray[0] == 0) {
            return new BigInteger(1, byArray);
        }
        return new BigInteger(byArray, 1);
    }

    public BigInteger modInverse(BigInteger bigInteger) throws ArithmeticException {
        if (bigInteger.signum != 1) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        BigInteger bigInteger2 = this.remainder(bigInteger);
        if (bigInteger2.signum < 0) {
            bigInteger2 = bigInteger2.add(bigInteger);
        }
        if (!bigInteger2.gcd(bigInteger).equals(ONE)) {
            throw new ArithmeticException("BigInteger not invertible");
        }
        return new BigInteger(BigInteger.plumbModInverse(bigInteger2.magnitude, bigInteger.magnitude), 1);
    }

    public BigInteger shiftLeft(int n) {
        if (n == 0) {
            return this;
        }
        if (n < 0) {
            return this.shiftRight(-n);
        }
        int n2 = n / 8;
        int n3 = n % 8;
        byte[] byArray = new byte[(this.bitLength() + n) / 8 + 1];
        if (n3 == 0) {
            int n4 = n2;
            while (n4 < byArray.length) {
                byArray[byArray.length - 1 - n4] = this.getByte(n4 - n2);
                ++n4;
            }
        } else {
            int n5 = n2;
            while (n5 < byArray.length) {
                byArray[byArray.length - 1 - n5] = (byte)(this.getByte(n5 - n2) << n3 | (n5 == n2 ? 0 : (this.getByte(n5 - n2 - 1) & 0xFF) >> 8 - n3));
                ++n5;
            }
        }
        return BigInteger.valueOf(byArray);
    }

    public BigInteger shiftRight(int n) {
        if (n == 0) {
            return this;
        }
        if (n < 0) {
            return this.shiftLeft(-n);
        }
        if (n >= this.bitLength()) {
            if (this.signum < 0) {
                return BigInteger.valueOf(-1L);
            }
            return ZERO;
        }
        int n2 = n / 8;
        int n3 = n % 8;
        byte[] byArray = new byte[(this.bitLength - n) / 8 + 1];
        if (n3 == 0) {
            int n4 = 0;
            while (n4 < byArray.length) {
                byArray[byArray.length - 1 - n4] = this.getByte(n2 + n4);
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < byArray.length) {
                byArray[byArray.length - 1 - n5] = (byte)((this.getByte(n2 + n5 + 1) << 8 | this.getByte(n2 + n5) & 0xFF) >> n3);
                ++n5;
            }
        }
        return BigInteger.valueOf(byArray);
    }

    public BigInteger and(BigInteger bigInteger) {
        byte[] byArray = new byte[Math.max(this.byteLength(), bigInteger.byteLength())];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)(this.getByte(byArray.length - n - 1) & bigInteger.getByte(byArray.length - n - 1));
            ++n;
        }
        return BigInteger.valueOf(byArray);
    }

    public BigInteger or(BigInteger bigInteger) {
        byte[] byArray = new byte[Math.max(this.byteLength(), bigInteger.byteLength())];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)(this.getByte(byArray.length - n - 1) | bigInteger.getByte(byArray.length - n - 1));
            ++n;
        }
        return BigInteger.valueOf(byArray);
    }

    public BigInteger xor(BigInteger bigInteger) {
        byte[] byArray = new byte[Math.max(this.byteLength(), bigInteger.byteLength())];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)(this.getByte(byArray.length - n - 1) ^ bigInteger.getByte(byArray.length - n - 1));
            ++n;
        }
        return BigInteger.valueOf(byArray);
    }

    public BigInteger not() {
        byte[] byArray = new byte[this.byteLength()];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = ~this.getByte(byArray.length - n - 1);
            ++n;
        }
        return BigInteger.valueOf(byArray);
    }

    public BigInteger andNot(BigInteger bigInteger) {
        byte[] byArray = new byte[Math.max(this.byteLength(), bigInteger.byteLength())];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)(this.getByte(byArray.length - n - 1) & ~bigInteger.getByte(byArray.length - n - 1));
            ++n;
        }
        return BigInteger.valueOf(byArray);
    }

    public boolean testBit(int n) throws ArithmeticException {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        return (this.getByte(n / 8) & 1 << n % 8) != 0;
    }

    public BigInteger setBit(int n) throws ArithmeticException {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        int n2 = n / 8;
        byte[] byArray = new byte[Math.max(this.byteLength(), n2 + 2)];
        int n3 = 0;
        while (n3 < byArray.length) {
            byArray[byArray.length - n3 - 1] = this.getByte(n3);
            ++n3;
        }
        int n4 = byArray.length - n2 - 1;
        byArray[n4] = (byte)(byArray[n4] | 1 << n % 8);
        return BigInteger.valueOf(byArray);
    }

    public BigInteger clearBit(int n) throws ArithmeticException {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        int n2 = n / 8;
        byte[] byArray = new byte[Math.max(this.byteLength(), (n + 1) / 8 + 1)];
        int n3 = 0;
        while (n3 < byArray.length) {
            byArray[byArray.length - n3 - 1] = this.getByte(n3);
            ++n3;
        }
        int n4 = byArray.length - n2 - 1;
        byArray[n4] = (byte)(byArray[n4] & ~(1 << n % 8));
        return BigInteger.valueOf(byArray);
    }

    public BigInteger flipBit(int n) throws ArithmeticException {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        int n2 = n / 8;
        byte[] byArray = new byte[Math.max(this.byteLength(), n2 + 2)];
        int n3 = 0;
        while (n3 < byArray.length) {
            byArray[byArray.length - n3 - 1] = this.getByte(n3);
            ++n3;
        }
        int n4 = byArray.length - n2 - 1;
        byArray[n4] = (byte)(byArray[n4] ^ 1 << n % 8);
        return BigInteger.valueOf(byArray);
    }

    public int getLowestSetBit() {
        if (this.lowestSetBit == -2) {
            if (this.signum == 0) {
                this.lowestSetBit = -1;
            } else {
                byte by;
                int n = 0;
                while ((by = this.getByte(n)) == 0) {
                    ++n;
                }
                this.lowestSetBit = 8 * n + trailingZeroCnt[by & 0xFF];
            }
        }
        return this.lowestSetBit;
    }

    public int bitLength() {
        if (this.bitLength == -1) {
            if (this.signum == 0) {
                this.bitLength = 0;
            } else {
                int n = 8 * (this.magnitude.length - 1) + bitLen[this.magnitude[0] & 0xFF];
                if (this.signum < 0) {
                    boolean bl = bitCnt[this.magnitude[0] & 0xFF] == 1;
                    int n2 = 1;
                    while (n2 < this.magnitude.length && bl) {
                        bl = this.magnitude[n2] == 0;
                        ++n2;
                    }
                    this.bitLength = bl ? n - 1 : n;
                } else {
                    this.bitLength = n;
                }
            }
        }
        return this.bitLength;
    }

    public int bitCount() {
        if (this.bitCount == -1) {
            int n = 0;
            int n2 = 0;
            while (n2 < this.magnitude.length) {
                n += bitCnt[this.magnitude[n2] & 0xFF];
                ++n2;
            }
            if (this.signum < 0) {
                int n3 = 0;
                int n4 = this.magnitude.length - 1;
                while (this.magnitude[n4] == 0) {
                    n3 += 8;
                    --n4;
                }
                this.bitCount = n + (n3 += trailingZeroCnt[this.magnitude[n4] & 0xFF]) - 1;
            } else {
                this.bitCount = n;
            }
        }
        return this.bitCount;
    }

    public boolean isProbablePrime(int n) {
        int n2 = n / 2;
        if (n2 <= 0) {
            return true;
        }
        BigInteger bigInteger = this.abs();
        if (bigInteger.equals(TWO)) {
            return true;
        }
        if (!bigInteger.testBit(0) || bigInteger.equals(ONE)) {
            return false;
        }
        BigInteger bigInteger2 = bigInteger.subtract(ONE);
        int n3 = bigInteger2.getLowestSetBit();
        bigInteger2 = bigInteger2.shiftRight(n3);
        Random random = new Random();
        int n4 = 0;
        while (n4 < n2) {
            BigInteger bigInteger3;
            while ((bigInteger3 = new BigInteger(bigInteger.bitLength(), random)).compareTo(ONE) <= 0 || bigInteger3.compareTo(bigInteger) >= 0) {
            }
            int n5 = 0;
            BigInteger bigInteger4 = bigInteger3.modPow(bigInteger2, bigInteger);
            while (!(n5 == 0 && bigInteger4.equals(ONE) || bigInteger4.equals(bigInteger.subtract(ONE)))) {
                if (n5 > 0 && bigInteger4.equals(ONE) || ++n5 == n3) {
                    return false;
                }
                bigInteger4 = bigInteger4.modPow(TWO, bigInteger);
            }
            ++n4;
        }
        return true;
    }

    public int compareTo(BigInteger bigInteger) {
        if (this.signum == bigInteger.signum) {
            return this.signum * BigInteger.byteArrayCmp(this.magnitude, bigInteger.magnitude);
        }
        if (this.signum > bigInteger.signum) {
            return 1;
        }
        return -1;
    }

    private static int byteArrayCmp(byte[] byArray, byte[] byArray2) {
        if (byArray.length < byArray2.length) {
            return -1;
        }
        if (byArray.length > byArray2.length) {
            return 1;
        }
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n] & 0xFF;
            int n3 = byArray2[n] & 0xFF;
            if (n2 < n3) {
                return -1;
            }
            if (n2 > n3) {
                return 1;
            }
            ++n;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BigInteger)) {
            return false;
        }
        BigInteger bigInteger = (BigInteger)object;
        if (bigInteger.signum != this.signum || bigInteger.magnitude.length != this.magnitude.length) {
            return false;
        }
        if (bigInteger == this) {
            return true;
        }
        int n = 0;
        while (n < this.magnitude.length) {
            if (bigInteger.magnitude[n] != this.magnitude[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public BigInteger min(BigInteger bigInteger) {
        if (this.compareTo(bigInteger) < 0) {
            return this;
        }
        return bigInteger;
    }

    public BigInteger max(BigInteger bigInteger) {
        if (this.compareTo(bigInteger) > 0) {
            return this;
        }
        return bigInteger;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.magnitude.length) {
            n = 37 * n + (this.magnitude[n2] & 0xFF);
            ++n2;
        }
        return n * this.signum;
    }

    public String toString(int n) {
        Object object;
        if (this.signum == 0) {
            return "0";
        }
        if (n < 2 || n > 36) {
            n = 10;
        }
        int n2 = (this.magnitude.length + 6) / 7;
        String[] stringArray = new String[n2];
        Object object2 = this.abs();
        int n3 = 0;
        while (((BigInteger)object2).signum != 0) {
            object = ((BigInteger)object2).divideAndRemainder(longRadix[n]);
            stringArray[n3++] = Long.toString(object[1].longValue(), n);
            object2 = object[0];
        }
        object = new StringBuffer(n3 * digitsPerLong[n] + 1);
        if (this.signum < 0) {
            ((StringBuffer)object).append('-');
        }
        ((StringBuffer)object).append(stringArray[n3 - 1]);
        int n4 = n3 - 2;
        while (n4 >= 0) {
            int n5 = digitsPerLong[n] - stringArray[n4].length();
            if (n5 != 0) {
                ((StringBuffer)object).append(zeros[n5]);
            }
            ((StringBuffer)object).append(stringArray[n4]);
            --n4;
        }
        return ((StringBuffer)object).toString();
    }

    public String toString() {
        return this.toString(10);
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.byteLength()];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = this.getByte(byArray.length - n - 1);
            ++n;
        }
        return byArray;
    }

    public int intValue() {
        int n = 0;
        int n2 = 3;
        while (n2 >= 0) {
            n = (n << 8) + (this.getByte(n2) & 0xFF);
            --n2;
        }
        return n;
    }

    public long longValue() {
        long l = 0L;
        int n = 7;
        while (n >= 0) {
            l = (l << 8) + (long)(this.getByte(n) & 0xFF);
            --n;
        }
        return l;
    }

    public float floatValue() {
        return Float.valueOf(this.toString()).floatValue();
    }

    public double doubleValue() {
        return Double.valueOf(this.toString());
    }

    private static byte[] stripLeadingZeroBytes(byte[] byArray) {
        int n = 0;
        while (n < byArray.length && byArray[n] == 0) {
            ++n;
        }
        byte[] byArray2 = new byte[byArray.length - n];
        int n2 = n;
        while (n2 < byArray.length) {
            byArray2[n2 - n] = byArray[n2];
            ++n2;
        }
        return byArray2;
    }

    private static byte[] makePositive(byte[] byArray) {
        int n;
        int n2 = 0;
        while (n2 < byArray.length && byArray[n2] == -1) {
            ++n2;
        }
        int n3 = n2;
        while (n3 < byArray.length && byArray[n3] == 0) {
            ++n3;
        }
        int n4 = n3 == byArray.length ? 1 : 0;
        byte[] byArray2 = new byte[byArray.length - n2 + n4];
        int n5 = n2;
        while (n5 < byArray.length) {
            byArray2[n5 - n2 + n4] = ~byArray[n5];
            ++n5;
        }
        int n6 = byArray2.length - 1;
        do {
            n = n6--;
        } while ((byArray2[n] = (byte)(byArray2[n] + 1)) == 0);
        return byArray2;
    }

    private int byteLength() {
        return this.bitLength() / 8 + 1;
    }

    private int signBit() {
        if (this.signum < 0) {
            return 1;
        }
        return 0;
    }

    private byte signByte() {
        return (byte)(this.signum < 0 ? -1 : 0);
    }

    private byte getByte(int n) {
        if (n >= this.magnitude.length) {
            return this.signByte();
        }
        int n2 = this.magnitude[this.magnitude.length - n - 1];
        return (byte)(this.signum >= 0 ? n2 : (n <= this.firstNonzeroByteNum() ? -n2 : ~n2));
    }

    private int firstNonzeroByteNum() {
        if (this.firstNonzeroByteNum == -2) {
            int n = this.magnitude.length - 1;
            while (n >= 0 && this.magnitude[n] == 0) {
                --n;
            }
            this.firstNonzeroByteNum = this.magnitude.length - n - 1;
        }
        return this.firstNonzeroByteNum;
    }

    private static native void plumbInit();

    private static native byte[] plumbAdd(byte[] var0, byte[] var1);

    private static native BigInteger plumbSubtract(byte[] var0, byte[] var1);

    private static native byte[] plumbMultiply(byte[] var0, byte[] var1);

    private static native byte[] plumbDivide(byte[] var0, byte[] var1);

    private static native byte[] plumbRemainder(byte[] var0, byte[] var1);

    private static native byte[][] plumbDivideAndRemainder(byte[] var0, byte[] var1);

    private static native byte[] plumbGcd(byte[] var0, byte[] var1);

    private static native byte[] plumbModPow(byte[] var0, byte[] var1, byte[] var2);

    private static native byte[] plumbModInverse(byte[] var0, byte[] var1);

    private static native byte[] plumbSquare(byte[] var0);

    private static native byte[] plumbGeneratePrime(byte[] var0);

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.magnitude = (byte[])this.magnitude.clone();
        if (this.signum < -1 || this.signum > 1) {
            throw new StreamCorruptedException("BigInteger: Invalid signum value");
        }
        if (this.magnitude.length == 0 != (this.signum == 0)) {
            throw new StreamCorruptedException("BigInteger: signum-magnitude mismatch");
        }
        this.bitLength = -1;
        this.bitCount = -1;
        this.firstNonzeroByteNum = -2;
        this.lowestSetBit = -2;
    }

    static {
        int n = 1;
        while (n <= 16) {
            byte[] byArray = new byte[]{(byte)n};
            BigInteger.posConst[n] = new BigInteger(byArray, 1);
            BigInteger.negConst[n] = new BigInteger(byArray, -1);
            ++n;
        }
        bitLen = new byte[]{0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
        bitCnt = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
        trailingZeroCnt = new byte[]{8, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};
        zeros = new String[64];
        BigInteger.zeros[63] = "000000000000000000000000000000000000000000000000000000000000000";
        n = 0;
        while (n < 63) {
            BigInteger.zeros[n] = zeros[63].substring(0, n);
            ++n;
        }
        SecurityManager.enablePrivilege("UniversalLinkAccess");
        System.loadLibrary("jbn3240");
        SecurityManager.revertPrivilege();
        BigInteger.plumbInit();
        ONE = BigInteger.valueOf(1L);
        TWO = BigInteger.valueOf(2L);
        ZERO_CHAR = Character.forDigit(0, 2);
        digitsPerLong = new int[]{0, 0, 62, 39, 31, 27, 24, 22, 20, 19, 18, 18, 17, 17, 16, 16, 15, 15, 15, 14, 14, 14, 14, 13, 13, 13, 13, 13, 13, 12, 12, 12, 12, 12, 12, 12, 12};
        longRadix = new BigInteger[]{null, null, BigInteger.valueOf(0x4000000000000000L), BigInteger.valueOf(4052555153018976267L), BigInteger.valueOf(0x4000000000000000L), BigInteger.valueOf(7450580596923828125L), BigInteger.valueOf(4738381338321616896L), BigInteger.valueOf(3909821048582988049L), BigInteger.valueOf(0x1000000000000000L), BigInteger.valueOf(1350851717672992089L), BigInteger.valueOf(1000000000000000000L), BigInteger.valueOf(5559917313492231481L), BigInteger.valueOf(2218611106740436992L), BigInteger.valueOf(8650415919381337933L), BigInteger.valueOf(2177953337809371136L), BigInteger.valueOf(6568408355712890625L), BigInteger.valueOf(0x1000000000000000L), BigInteger.valueOf(2862423051509815793L), BigInteger.valueOf(6746640616477458432L), BigInteger.valueOf(799006685782884121L), BigInteger.valueOf(1638400000000000000L), BigInteger.valueOf(3243919932521508681L), BigInteger.valueOf(6221821273427820544L), BigInteger.valueOf(504036361936467383L), BigInteger.valueOf(876488338465357824L), BigInteger.valueOf(1490116119384765625L), BigInteger.valueOf(2481152873203736576L), BigInteger.valueOf(4052555153018976267L), BigInteger.valueOf(6502111422497947648L), BigInteger.valueOf(353814783205469041L), BigInteger.valueOf(531441000000000000L), BigInteger.valueOf(787662783788549761L), BigInteger.valueOf(0x1000000000000000L), BigInteger.valueOf(1667889514952984961L), BigInteger.valueOf(2386420683693101056L), BigInteger.valueOf(3379220508056640625L), BigInteger.valueOf(4738381338321616896L)};
    }
}

