/* $Id: newgroups.c,v 1.1.1.1 1998/07/29 15:14:29 proff Exp $
 * $Copyright$
 */

#include "nglobal.h"

#include "group.h"

#include "newgroups.h"

static int c2i(char *s)
{
	if (!isdigit(s[0]) || !isdigit(s[1]))
		return -1;
	return (s[0]-'0')*10+(s[1]-'0');
}

EXPORT bool CMDnewgroups(char *args)
{
	struct newsgroup *n;
	time_t tim;
	struct tm tm;
	char d[13];
	char gmt[4]="";
	char dist[128]="";
	int i;
	int t[6];
	memset(d, 0, sizeof d);
	if (sscanf(args, "%*s %6s %6s %3s <%127s>", d, d+6, gmt, dist)<2)
	{
bad:
		emitrn("501 yymmdd hhmmss [\"GMT\"] [<distributions>]");
		return FALSE;
	}
	for (i=0; i<6; i++)
		if ((t[i]=c2i(d+2*i))==-1)
			goto bad;
	memset(&tm, 0, sizeof tm);
	tm.tm_year = t[0];
	tm.tm_mon = t[1]-1;
	tm.tm_mday = t[2];
	tm.tm_hour = t[3];
	tm.tm_min = t[4];
	tm.tm_sec = t[5];
	if ((tim=mktime(&tm))==-1)
		goto bad;
	emitrn (NNTP_NEWGROUPS_FOLLOWS);
	for (n=Ni->newsgroup_head; n; n=n->next)
	{
#ifdef READ_LOCKS
		if (!newsgroupLockRead(n))
			continue;
#endif
		if (!n->moderation ||
		    n->creation_time < tim ||
		    (con->groupSecurity && !authGroup(n->group, FALSE)))
		    	goto cont;
		if (*dist)
		{
			char *p;
			for (p=dist;;)
			{
				char *p2=strchr(p, ',');
				if (strnCaseEq(n->group, p, p2? p2-p: strlen(p)))
					goto good;
				if (!p2)
					break;
				p=p2+1;
			}
			goto cont;
		}
	good:
		emitf ("%s %d %d %c\r\n", n->group, getHi(n), getLo(n), n->moderation);
	cont:
#ifdef READ_LOCKS
		n->read_locks--;
#else
		continue;
#endif
	}
	emitrn (".");
	return TRUE;
}
