open Code;;
open Stockage;;
open Lexuniv;;

let registre = parser
  | [< 'MC "r"; 'Entier nbr >] -> nbr
  | [< 'MC "sp" >] -> sp
  | [< 'MC "ra" >] -> ra;;

let constante = parser
  | [< 'Entier nbr >] -> nbr
  | [< 'Ident nom_tiq >] -> valeur_tiquette nom_tiq;;

let oprande = parser
  | [< r = registre >] -> Reg r
  | [< c = constante >] -> Imm c;;

let rec instruction = parser
  | [< op = opration; (r1, o, r2) = reg_op_reg >] ->
          assemble(Op(op, r1, o, r2))
  | [< test = test_invers; (r1, o, r2) = reg_op_reg >] ->
          assemble(Op(test, r1, o, r2));
          assemble(Op(Seq, r2, Reg 0, r2))
  | [< 'MC "jmp"; o = oprande; 'MC ","; r = registre >] ->
          assemble(Jmp(o, r))
  | [< 'MC "braz"; r = registre; 'MC ","; c = constante >] ->
          assemble(Braz(r, c))
  | [< 'MC "branz"; r = registre; 'MC ","; c = constante >] ->
          assemble(Branz(r, c))
  | [< 'MC "scall"; 'Entier n >] -> assemble (Scall n)
  | [< 'MC "write" >] -> assemble (Scall 1)
  | [< 'MC "read" >] -> assemble (Scall 0)
  | [< 'MC "stop" >] -> assemble Stop

and reg_op_reg = parser
  | [< r1 = registre; 'MC ","; o = oprande; 'MC ","; r2 = registre >] ->
      (r1, o, r2)

and opration = parser
  | [< 'MC "load" >] -> Load    | [< 'MC "store" >] -> Store
  | [< 'MC "add" >]  -> Add     | [< 'MC "mult" >]  -> Mult
  | [< 'MC "sub" >]  -> Sub     | [< 'MC "div" >]   -> Div
  | [< 'MC "and" >]  -> And     | [< 'MC "or" >]    -> Or
  | [< 'MC "xor" >]  -> Xor     | [< 'MC "shl" >]   -> Shl
  | [< 'MC "shr" >]  -> Shr     | [< 'MC "slt" >]   -> Slt
  | [< 'MC "sle" >]  -> Sle     | [< 'MC "seq" >]   -> Seq

and test_invers = parser
  | [< 'MC "sgt" >] -> Sle
  | [< 'MC "sge" >] -> Slt
  | [< 'MC "sne" >] -> Seq;;

let dfinition_d'tiquette = parser
  | [< 'Ident nom_tiq; 'MC ":" >] -> poser_tiquette nom_tiq;;

let rec instruction_tiq = parser
  | [< _ = dfinition_d'tiquette; _ = instruction_tiq >] -> ()
  | [< _ = instruction >] -> ();;

let rec suite_d'instructions = parser
  | [< _ = instruction_tiq; flux >] -> suite_d'instructions flux
  | [< >] -> ();;

let analyseur_lexical =
    construire_analyseur
      ["r"; "sp"; "ra"; "load"; "store"; "add"; "mult"; "sub"; "div";
       "and"; "or"; "xor"; "shl"; "shr"; "sgt"; "sge"; "sne"; 
       "slt"; "sle"; "seq"; "jmp"; "braz"; "branz";
       "scall"; "write"; "read"; "stop"; ","; ":"];;

let programme flux =
    initialise ();
    suite_d'instructions (analyseur_lexical flux);
    extraire_code ();;
