
#include "playlist_utils.h"


#if Log_Enabled
	enum {gBuffSize = 532, gBuffMaxStr = 512};
	
	enum {switchEntries, switchTime, switchBytes};
	
	enum {gLogMaxBytes = 100000};
	enum {gLogMaxEntries = 1000};
	enum {gLogMaxMilliSecs = 3 * 60 * 1000};


	static int gLogSwitchSetting = switchEntries;
	static long gLogEntries  = 0;
	static SInt64 gLogTimeStart = 0;
	static long gLogNumBytes = 0;
	static gLogNumPackets = 0;
	static char gTempStr[256];
	static FILE *gLogFile_1 = 0;
	static FILE *gLogFile_2 = 0;
	static FILE *gLogFileCurrent = 0;
	static int gFileNum = 1;
	
	static bool gLogStarted = false;
	static char gLogBuff[gBuffSize];
	static int gBuffUsed = 0;



void	LogFileOpen(void)  
{
	if (!gLogFile_1 && !gLogFile_2)
	{ 	gLogFile_1 = fopen("logfile_1.txt","w");
		gLogFileCurrent = gLogFile_1;
  		*gLogBuff = 0;
   		gLogTimeStart =  PlayListUtils::Milliseconds();
   		gLogStarted = true;
		gLogEntries = 0;
		gLogTimeStart = 0;
		gLogNumBytes = 0;
		gLogNumPackets = 0;
		gFileNum = 1;
		gBuffUsed = 0;
  	}
}

void	LogFileClose(void)
{
	fclose(gLogFile_1);
	fclose(gLogFile_2);
	gLogFileCurrent = gLogFile_1 = gLogFile_2 = 0;
	
}

bool TimeToSwitch(int len)
{
	bool timeToSwitch = false;
	if (!gLogStarted) return timeToSwitch;
	  
	switch( gLogSwitchSetting ) 
	{
		case switchEntries:
			if (gLogEntries >= gLogMaxEntries)
			{	timeToSwitch = true;
				gLogEntries = 1;
			}
			else 
				gLogEntries ++;
		break;
		
		case switchTime:
		{	SInt64 timeNow = PlayListUtils::Milliseconds();
			SInt64 timeThisFile = timeNow - gLogTimeStart;
			if ( timeThisFile >  gLogMaxMilliSecs )
			{	timeToSwitch = true;
				gLogTimeStart = timeNow;
			}
		}
		break;
		
		case switchBytes:
			if (gLogNumBytes > gLogMaxBytes)
			{	timeToSwitch = true;
				gLogNumBytes = 0;
			}
			gLogNumBytes += len;
		break;
	};
	 

	return timeToSwitch;

}

void WriteToLog(void *data, int len)
{
	if (gLogFileCurrent && data && len)
	{
		bool timetoswitch =  TimeToSwitch(len);
		if ( timetoswitch )
		{	
			if (gFileNum == 1)
			{
				if (gLogFile_1) fclose(gLogFile_1);
				gLogFile_1 = 0;
				gLogFile_2 = fopen("logfile_2.txt","w");
				gFileNum = 2;

				gLogFileCurrent = gLogFile_2;
                fseek(gLogFileCurrent , 0, SEEK_SET);
			}
			else
			{	
				if (gLogFile_2) fclose(gLogFile_2);
				gLogFile_2 = 0;
				gLogFile_1 = fopen("logfile_1.txt","w");
				gFileNum = 1;
			
				gLogFileCurrent = gLogFile_1;
                fseek(gLogFileCurrent , 0, SEEK_SET);
			}
		}
		fwrite(data, sizeof(char), len, gLogFileCurrent);
		fflush(gLogFileCurrent);		
	}
}

void WritePacketToLog(void *data, int len)
{
	gLogNumPackets ++;
	LogUInt("Packet:", (UInt32) gLogNumPackets,"\n");
	LogBuffer();
	WriteToLog(data, len);
}

void WritToBuffer(void *data, int len)
{
	if (data )
	{
		if (len >= gBuffSize)
			len = gBuffSize -1;
		memcpy (gLogBuff, (char *) data, len);
		gLogBuff[gBuffSize] = 0;
	}
   gBuffUsed = len;
}

void LogBuffer(void)
{	
	WriteToLog(gLogBuff, strlen(gLogBuff) );
	*gLogBuff =0;
	gBuffUsed = strlen(gLogBuff);
}

void PrintLogBuffer(bool log)
{
	printf(gLogBuff);
	if (log) LogBuffer();
	*gLogBuff =0;
    gBuffUsed = strlen(gLogBuff);
}

void LogNum(char *str1,char *str2,char *str3)
{
	int size = strlen(str1) + strlen(str2) + strlen(str3);
	if ( size < gBuffMaxStr ) 
    	sprintf(gLogBuff, "%s%s%s%s",gLogBuff, str1, str2,str3); 
   
   gBuffUsed = strlen(gLogBuff);
}

void  LogFloat(char *str, float num, char *str2)
{
	sprintf(gTempStr,"%f",num);
	LogNum(str,gTempStr,str2);
}

void LogInt(char *str, long num, char *str2)
{
	sprintf(gTempStr,"%ld",num);
	LogNum(str,gTempStr,str2);
}

void LogUInt (char *str, unsigned long num, char *str2)
{
	sprintf(gTempStr,"%lu",num);
	LogNum(str,gTempStr,str2);
}

void LogStr(char *str)
{
   *gLogBuff = 0;
	int size = strlen(str) + gBuffUsed;
	if ( size <= gBuffMaxStr ) 
   		sprintf(gLogBuff, "%s%s",gLogBuff, str); 
   gBuffUsed = strlen(gLogBuff);
}

#endif


double 	PlayListUtils::sDivisor = 0;
double  PlayListUtils::sMicroDivisor = 0;
SInt64  PlayListUtils::sMsecSince1900 = 0;
SInt64  PlayListUtils::sInitialMsec = 0;
		


void PlayListUtils::InitRandom()
{
	SInt64 theMilliseconds = Milliseconds();
	::srand((unsigned int)theMilliseconds);
	::srand(rand());
}

void PlayListUtils::InitMilliSeconds()
{
#if __MacOSX__
	//Setup divisor for milliseconds
	double divisorNumerator = 0;
	double divisorDenominator = 0;
	struct timescale theTimescale;
	
	(void)utimescale(&theTimescale);
	
	divisorNumerator = (double)theTimescale.tsc_numerator;
	divisorDenominator = (double)theTimescale.tsc_denominator;//we want milliseconds, not micro
	sMicroDivisor = divisorNumerator / divisorDenominator;
	divisorDenominator *= 1000;//we want milliseconds, not micro
	sDivisor = divisorNumerator / divisorDenominator;
#endif

	//setup t0 value for msec since 1900
	struct timeval t;
	struct timezone tz;
	int theErr = ::gettimeofday(&t, &tz);

	//t.tv_sec is number of seconds since Jan 1, 1970. Convert to seconds since 1900
	sMsecSince1900 = 24 * 60 * 60;
	sMsecSince1900 *= (70 * 365) + 17;
	sMsecSince1900 += (SInt64)t.tv_sec;
	sMsecSince1900 *= 1000;//convert to msec from sec
	
	sInitialMsec = Milliseconds();
}


PlayListUtils::PlayListUtils()
{

	InitMilliSeconds();
	InitRandom();	
}

SInt64 PlayListUtils::Microseconds()
{
#if __MacOSX__
	UInt64 theCurTime = timestamp();	
	double theDoubleTime = (double)theCurTime;
	theDoubleTime *= sMicroDivisor;
	return (SInt64)theDoubleTime;
#else
	struct timeval t;
	struct timezone tz;
	int theErr = ::gettimeofday(&t, &tz);

/*
	SInt64 curTime;
	curTime = t.tv_sec;
	curTime *= 1000;		// sec -> msec
	curTime += t.tv_usec;
	return curTime - (sInitialMsec * eMilli);
*/
	SInt64 curTime;
	curTime = t.tv_sec;
	curTime *= eMicro;		// sec -> msec
	curTime += t.tv_usec;

	return curTime;
#endif
}

SInt64 PlayListUtils::Milliseconds()
{

#if __MacOSX__
	SInt64 theCurTime;

	//DMS - here is that superfast way of getting milliseconds. Note that this is time
	//relative to when the machine booted.
	UInt64 curTime = timestamp();
	
	double theDoubleTime = (double)curTime;
	theDoubleTime *= sDivisor;
	theCurTime = ((SInt64)theDoubleTime) ;
	
	return theCurTime;
#else
	struct timeval t;
	struct timezone tz;
	int theErr = ::gettimeofday(&t, &tz);

/*
	SInt64 curTime;
	curTime = t.tv_sec;
	curTime *= 1000;				// sec -> msec
	curTime += t.tv_usec / 1000;	// usec -> msec

	return curTime - sInitialMsec;
*/
	SInt64 curTime;
	curTime = t.tv_sec;
	curTime *= 1000;				// sec -> msec
	curTime += t.tv_usec / 1000;	// usec -> msec

	return curTime;
#endif

}


UInt32 PlayListUtils::Random()
{
	UInt32 			theRandomNum ;
	theRandomNum = ::rand();
	return theRandomNum;
}
