/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
// $Id: QTAtom_stts.h,v 1.3 1999/04/15 22:36:16 lecroy Exp $
//
// QTAtom_stts:
//   The 'stts' QTAtom class.

#ifndef QTAtom_stts_H
#define QTAtom_stts_H


//
// Includes
#include "QTFile.h"
#include "QTAtom.h"


//
// Class state cookie
class QTAtom_stts_SampleTableControlBlock {

public:
	//
	// Constructor and destructor.
						QTAtom_stts_SampleTableControlBlock(void);
	virtual				~QTAtom_stts_SampleTableControlBlock(void);
	
	//
	// Reset function
			void		Reset(void);

	//
	// MT->SN Sample table cache
	UInt32				fMTtSN_CurEntry;
	UInt32				fMTtSN_CurMediaTime, fMTtSN_CurSample;
	
	//
	/// SN->MT Sample table cache
	UInt32				fSNtMT_CurEntry;
	UInt32				fSNtMT_CurMediaTime, fSNtMT_CurSample;
};


//
// QTAtom class
class QTAtom_stts : public QTAtom {

public:
	//
	// Constructors and destructor.
						QTAtom_stts(QTFile * File, QTFile::AtomTOCEntry * Atom,
							   bool Debug = false, bool DeepDebug = false);
	virtual				~QTAtom_stts(void);


	//
	// Initialization functions.
	virtual	bool		Initialize(void);
	
	//
	// Accessors.
			bool		MediaTimeToSampleNumber(UInt32 MediaTime, UInt32 * SampleNumber = NULL,
												QTAtom_stts_SampleTableControlBlock * STCB = NULL);
			bool		SampleNumberToMediaTime(UInt32 SampleNumber, UInt32 * MediaTime = NULL,
												QTAtom_stts_SampleTableControlBlock * STCB = NULL);


	//
	// Debugging functions.
	virtual	void		DumpAtom(void);


protected:
	//
	// Protected member variables.
	UInt8		fVersion;
	UInt32		fFlags; // 24 bits in the low 3 bytes

	UInt32		fNumEntries;
	char		*fTimeToSampleTable;
	
	QTAtom_stts_SampleTableControlBlock	fDefaultSTCB;
};

#endif // QTAtom_stts_H
