/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		RTCPDebugModule.cpp

	Contains:	Just printf's RTCP packerts
	
	$Log: RTCPDebugModule.cpp,v $
	Revision 1.0  1999/03/02 23:08:29  cl
	Created
	

*/

#ifdef DEBUG_RTCP_PACKETS


#include "RTCPDebugModule.h"
#include "RTCPPacket.h"
#include "RTCPAPPPacket.h"


void RTCPDebugModule::ProcessRTCPPacket(RTPStream* /*inStream*/, StrPtrLen* inPacket)
{
	UInt8* workBuffer = (UInt8*)inPacket->Ptr;
	
	while ( workBuffer < ((UInt8*)inPacket->Ptr+inPacket->Len) )
	{
		RTCPPacket rtcpPacket(workBuffer);
		
		switch (rtcpPacket.GetPacketType())
		{
			case RTCPReceiverPacket::kPacketType:
			{
				RTCPReceiverPacket receiverPacket(workBuffer);
				receiverPacket.Dump();
				
			}
			break;
			
			case RTCPCompressedQTSSPacket::kPacketType:
			{
				RTCPCompressedQTSSPacket compressedQTSSPacket(workBuffer);
				compressedQTSSPacket.Dump();
			}
			break;
			
			case SourceDescriptionPacket::kPacketType:
			{
				SourceDescriptionPacket sedsPacket(workBuffer);
				sedsPacket.Dump();
			}
			break;
			
			default:
				WarnV(false, "Unknown RTCP Packet Type");
				rtcpPacket.Dump();
			break;
		
		}
		
		
		workBuffer += (rtcpPacket.GetPacketLength() * 4 ) + 4;
	}
	
	return NULL;

}



#endif	//DEBUG_RTCP_PACKETS
