/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		SessionDictionary.h

	Contains:	
					
	$Log: SessionDictionary.h,v $

	Created: Tue, Mar 2, 1999 @ 4:23 PM
*/

#ifndef __SESSIONDICTIONARY_H__
#define __SESSIONDICTIONARY_H__

#include "Dictionary.h"


class SessionDictionary : public Dictionary
{
public:
	SessionDictionary();
	virtual ~SessionDictionary();
	void SetStandardValue(UInt32 inStdValueIndex, const void* inValueBuffer, UInt32 inBufferLen);
	void* GetStandardValue(UInt32 inStdValueIndex, void* ioValueBuffer, UInt32 inBufferLen, UInt32* ioValueLen);
	UInt32 GetStandardUInt32Value(UInt32 inStdValueIndex, bool* ioWasFound = NULL);
	UInt16 GetStandardUInt16Value(UInt32 inStdValueIndex, bool* ioWasFound );
	
	
	
	//"Standard" dictionary "indexes"
	enum {
		kVideoCodecName = 0,
		kAudioCodecName = 1,
		kMovieDuration = 2,
		kMovieSizeInBytes = 3,
		kLastRTSPURL = 4,
		kLastRTSPUserAgent = 5,
		
		//count of the above items
		kStdSignatureCount = 6
	};
	
	enum
	{
		kVideoCodecNameSig = 'vcod',	//All are FourCharCode
		kAudioCodecNameSig = 'acod',
		kMovieDurationSig = 'mdur',
		kMovieSizeInBytesSig = 'msiz',
		kLastRTSPURLSig = 'rurl',
		kLastRTSPUserAgentSig = 'rusa'
	};
		
	
protected:
	struct SigAndID {
		FourCharCode	valueSignature;
		UInt32			valueID;
	};
	
	static SigAndID sSigAndValueMap[kStdSignatureCount];
	
	
	
	class StaticInit
	{
		public:
			StaticInit();
	};
	static StaticInit sStaticInit;

};

#endif // __SESSIONDICTIONARY_H__

