/*
 * RTLinux signal support
 *
 * Written by Michael Barabanov
 * Copyright (C)Finite State Machine Labs Inc. , 2000
 * Released under the terms of the GP Version 2L
 *
 */

/*
 * RTLinux signal and the user-level RTLinux signals conflict.
 * This is ok since users should NOT be making RTLinux calls
 * from normal user code outside of PSC.  -- Cort
 */
#ifdef __RTLINUX_SIGNAL_H__
#error rtlinux_signal.h cannot be included with RTLinux posix/signal.h
#endif

#ifndef __RTL_SIGNAL_H__
#define __RTL_SIGNAL_H__

#define SA_FOCUS	0x00000008
#define SA_IRQ		0x00000010

typedef unsigned long rtl_sigset_t;

#define rtl_sigaddset(set, sig) set_bit(sig, set)
#define rtl_sigdelset(set, sig) clear_bit(sig, set)
#define rtl_sigismember(set, sig) test_bit(sig, set)
#define rtl_sigemptyset(set) do { *(set) = 0; } while (0)
#define rtl_sigfillset(set) do { *(set) = ~0; } while (0)

struct rtl_siginfo {
	int junk;
};

#ifndef __cplusplus
#include <linux/signal.h>
#endif

struct rtl_sigaction {
	union {
		void (*_sa_handler)(int);
		void (*_sa_sigaction)(int, struct rtl_siginfo *, void *);
	} _u;
	int sa_flags;
	unsigned long sa_focus;
	rtl_sigset_t sa_mask;
};

#define sa_sigaction _u._sa_sigaction
#define sa_handler _u._sa_handler
#define sigaction rtl_sigaction

#define RTL_SIGIRQMIN 256
#define RTL_SIGLOCALIRQMIN 512
#define RTL_SIGIRQMAX 1024

extern int sigaction(int sig, const struct sigaction *act, struct sigaction *oact);
extern int sigprocmask(int how, const rtl_sigset_t *set, rtl_sigset_t *oset);
extern int pthread_sigmask(int how, const rtl_sigset_t *set, rtl_sigset_t *oset);
extern int sigsuspend(const rtl_sigset_t *sigmask);
extern int sigpending(rtl_sigset_t *set);
extern int kill(pid_t pid, int sig);


#endif

