.TH obscont 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
obscont - observer based controller
.SH CALLING SEQUENCE
.nf
[K]=obscont(P,Kc,Kf)
[J,r]=obscont(P,Kc,Kf)
.fi
.SH PARAMETERS
.TP 10
P
: \fVsyslin\fR list (nominal plant) in state-space form, continuous 
or discrete time
.TP
Kc
: real matrix, (full state) controller gain
.TP
Kf
: real matrix, filter gain
.TP
K
: \fVsyslin\fR list (controller)
.TP
J
: \fVsyslin\fR list (extended controller)
.TP
r
: 1x2 row vector
.SH DESCRIPTION
\fVobscont\fR  returns the observer-based controller associated with a 
nominal plant \fVP\fR with matrices \fV[A,B,C,D]\fR (\fVsyslin\fR list).
.LP
The full-state control gain is \fVKc\fR and the filter gain is \fVKf\fR.
These gains can be computed, for example, by pole placement.
.LP
\fVA+B*Kc\fR and \fVA+Kf*C\fR are (usually) assumed stable.
.LP
\fVK\fR is a state-space representation of the 
compensator \fV K: y->u \fR in:
.LP
\fV xdot = A x + B u,  y=C x + D u, zdot= (A + Kf C)z -Kf y +B u, u=Kc z\fR 
.LP
\fVK\fR is a linear system (\fVsyslin\fR list) with matrices given by:
 \fVK=[A+B*Kc+Kf*C+Kf*D*Kc,Kf,-Kc]\fR.
.LP
The closed loop feedback system \fV Cl: v ->y \fR with
(negative) feedback \fVK\fR (i.e. \fVy = P u, u = v - K y\fR, or \fVxdot
= A x + B u, y = C x + D u, zdot = (A + Kf C) z - Kf y + B u, u = v -F z\fR)
is given by \fVCl = P/.(-K)\fR 
.LP
The poles of \fVCl\fR (\fV spec(cl('A')) \fR) are located at the eigenvalues of \fVA+B*Kc\fR
and \fVA+Kf*C\fR. 
.LP
Invoked with two output arguments \fVobscont\fR returns a
(square) linear system \fVK\fR which parametrizes all the stabilizing
feedbacks via a LFT.
.LP
Let \fVQ\fR an arbitrary stable linear system of dimension \fVr(2)\fRx\fVr(1)\fR
i.e. number of inputs x number of outputs in \fVP\fR.
Then any stabilizing controller \fVK\fR for \fVP\fR can be expressed as
\fVK=lft(J,r,Q)\fR. The controller which corresponds to \fVQ=0\fR is
\fVK=J(1:nu,1:ny)\fR (this \fVK\fR is returned by \fVK=obscont(P,Kc,Kf)\fR).
\fVr\fR is \fVsize(P)\fR i.e the vector [number of outputs, number of inputs];
.SH EXAMPLE
.nf
ny=2;nu=3;nx=4;P=ssrand(ny,nu,nx);[A,B,C,D]=abcd(P);
Kc=-ppol(A,B,[-1,-1,-1,-1]);  //Controller gain
Kf=-ppol(A',C',[-2,-2,-2,-2]);Kf=Kf';    //Observer gain
cl=P/.(-obscont(P,Kc,Kf));spec(cl('A'))   //closed loop system
[J,r]=obscont(P,Kc,Kf);
Q=ssrand(nu,ny,3);Q('A')=Q('A')-(maxi(real(spec(Q('A'))))+0.5)*eye(Q('A')) 
//Q is a stable parameter
K=lft(J,r,Q);
spec(h_cl(P,K))  // closed-loop A matrix (should be stable);
.fi
.SH SEE ALSO
ppol, lqg, lqr, lqe, h_inf, lft, syslin, feedback, observer
.SH AUTHOR
F.D. 


