.TH pfss 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
pfss - partial fraction decomposition
.SH CALLING SEQUENCE
.nf
elts=pfss(Sl)
elts=pfss(Sl,rmax)
elts=pfss(Sl,'cord')
elts=pfss(Sl,rmax,'cord')
.fi
.SH PARAMETERS
Sl
: \fVsyslin\fR list (state-space or transfer linear system)
rmax
: real number controlling the conditioning of block diagoanalization
cord
: character string \fV'c'\fR or \fV'd'\fR.
.SH DESCRIPTION
Partial fraction decomposition of the linear system \fVSl\fR (in state-space 
form, transfer matrices are automatically converted to state-space form
by \fVtf2ss\fR):
.LP
\fVelts\fR is the list of linear systems which add up to \fVSl\fR
i.e. \fVelts=list(S1,S2,S3,...,Sn)\fR with:
.LP
\fVSl = S1 + S2 +... +Sn\fR.
.LP
Each \fVSi\fR contains some poles of \fV\fRS according to the 
block-diagonalization of the \fVA\fR matrix of \fVS\fR.
.LP
For non proper systems the polynomial part of \fVSl\fR is put
in the last entry of \fVelts\fR.
.LP
If \fVSl\fR is given in transfer form, it is first converted into state-space
and each subsystem \fVSi\fR is then converted in transfer form.
.LP
The A matrix is of the state-space is put into block diagonal form
by function \fVbdiag\fR. The optional parameter \fVrmax\fR is sent to
\fVbdiag\fR. If \fVrmax\fR should be set to a large number to enforce
block-diagonalization. 
.LP
If the optional flag \fVcord='c'\fR is given the elements in \fVelts\fR
are sorted according to the real part (resp. magnitude if \fVcord='d'\fR)
of the eigenvalues of A matrices.
.SH EXAMPLE
.nf
W=ssrand(1,1,6);
elts=pfss(W); 
W1=0;for k=1:size(elts), W1=W1+ss2tf(elts(k));end
clean(ss2tf(W)-W1)
.fi 
.SH SEE ALSO
pbig, bdiag, coffg, dtsi
.SH AUTHOR
F.D.

