.TH cdfchi 1 "Dec 1997" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
cdfchi - cumulative distribution function chi-square distribution 
.SH CALLING SEQUENCE
.nf
[P,Q]=cdfchi("PQ",X,Df)
[X]=cdfchi("X",Df,P,Q);
[Df]=cdfchi("Df",P,Q,X)
.fi 
.SH PARAMETERS
.TP 10
P,Q,Xn,Df
: four real vectors of the same size.
.TP
P,Q (Q=1-P)
:  The integral from 0 to X of the chi-square
distribution.
Input range: [0, 1].
.TP
X
: Upper limit of integration of the non-central
chi-square distribution.
Input range: [0, +infinity).
Search range: [0,1E300]
.TP
Df
:  Degrees of freedom of the chi-square distribution.
Input range: (0, +infinity).
Search range: [ 1E-300, 1E300]
.SH DESCRIPTION
Calculates any one parameter of the chi-square
distribution given values for the others.
.LP
Formula    26.4.19   of Abramowitz  and     Stegun, Handbook  of
Mathematical Functions   (1966) is used   to reduce the chisqure
distribution to the incomplete distribution.
.LP
Computation of other parameters involve a seach for a value that
produces  the desired  value  of P.   The search relies  on  the
monotinicity of P with the other parameter.
.LP
From DCDFLIB: Library of Fortran Routines for Cumulative Distribution
Functions, Inverses, and Other Parameters (February, 1994)
Barry W. Brown, James Lovato and Kathy Russell. The University of
Texas.

