.TH splin G "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
splin - spline function
.SH CALLING SEQUENCE
.nf
d=splin(x,f [,"periodic"])
.fi
.SH PARAMETERS
.TP 10
x
: real vector
.TP
f 
: real vector of same size as \fVx\fR
.TP
"periodic"
: string flag (a periodic spline is looked for)
.SH DESCRIPTION
Given values \fVfi\fR of a function f at given points \fVxi\fR
(\fVfi=f(xi)\fR) this primitive computes a third order spline
function S which interpolates the function \fVf\fR.
The components of \fVx\fR must be in increasing order.
For a periodic spline \fVf(1)\fR must equal \fVf(n)\fR;
S is defined through the triple \fV(x,f,d)\fR where \fVd=spline(x,f)\fR
is the vector of the estimated derivatives of S at \fVxi\fR
(\fVfi=S(xi),di=S'(xi)\fR).
This function should be used in conjunction with \fVinterp\fR.
.LP
In the case "periodic" n must be choosen >= 3. In the non periodic 
case, n must be >= 4 (but n=3 gives some kind of results) and the
boundary/end conditions for the spline are of type 
"not-a-knot conditions" and prescribe  (if x1, x2, ..., xn are the 
interpolation nodes) :
.nf
    S'''(x2-) = S'''(x2+)
    S'''(x{n-1}-) = S'''(x{n-1}+)
.fi
so the first cubic polynomial p1 is equal to the second p2 and the
same is valid for the 2 last ones : p{n-2}=p{n-1}.
.SH EXAMPLE
.nf
x=0:0.5:10;f=sin(x);
d=splin(x,f);
S=interp(0:0.1:10,x,f,d);
plot2d(x',f',-1);
plot2d((0:0.1:10)',S',2,'000')
.fi
.SH SEE ALSO
interp, smooth


