.TH profile 1 "july 2000" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
profile - extract execution profiles of a Scilab function 
.SH CALLING SEQUENCE
.nf
c=profile(fun)
.fi
.SH PARAMETERS
.TP 4
fun
: a Scilab function 
.TP
c
: a nx3 matrix containig the execution profiles
.SH DESCRIPTION
To use \fVprofile\fR the Scilab function must have been prepared for
profiling (see getf).

For such function, When such a function is executed the systems counts
how many time each line is executed and how may cpu time is spend for
each line execution. These data are stored within the function data
structure.  The profile function allows to extract these data and
return them in the two first columns of \fVc\fR. The \fVc\fR third
column gives a measure of interpetor effort for one execution of
corresponding line. Ith line of \fVc\fR corresponds to Ith line of the
function (included first)

Note that, due to the precision of the processor clock (typically one
micro second), some executed lignes may appear with 0 cpu time even if
total cpu time really spend in their execution is large.


.SH EXAMPLE
.nf
//define function and prepare it for profiling
deff('x=foo(n)',['if n==0 then'
                 '  x=[]'
                 'else'
                 '  x=0'
                 '  for k=1:n'
                 '    s=svd(rand(n+10,n+10))'
                 '    x=x+s(1)'
                 '  end'
                 'end'],'p')
//call the function
foo(10)
//get execution profiles
profile(foo)
//call the function
foo(20)
profile(foo) //execution profiles are cumulated
.fi
.SH SEE ALSO
getf, deff, plotprofile, showprofile
