.TH showprofile 1 "july 2000" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
showprofile - extracts and displays execution profiles of a Scilab function 
.SH CALLING SEQUENCE
.nf
showprofile(fun)
.fi
.SH PARAMETERS
.TP 4
fun
: a Scilab function 
.SH DESCRIPTION
To use \fVshowprofile\fR the Scilab function must have been prepared for
profiling (see getf).

For such function, When such a function is executed the systems counts
how many time each line is executed and how may cpu time is spend for
each line execution. These data are stored within the function data
structure.  The \fVshowprofile\fR function outputs profiling results
(see \fprofile\fR) with text of the function lines.

Function text is rebuild with \fVfun2string\fR.
.SH EXAMPLE
.nf
//define function and prepare it for profiling
deff('x=foo(n)',['if n==0 then'
                 '  x=[]'
                 'else'
                 '  x=0'
                 '  for k=1:n'
                 '    s=svd(rand(n+10,n+10))'
                 '    x=x+s(1)'
                 '  end'
                 'end'],'p')
//call the function
foo(30)
//get execution profiles
showprofile(foo)
.fi
.SH SEE ALSO
profile, plotprofile, fun2string
